### Name: SparseM.hb
### Title: Harwell-Boeing Format Sparse Matrices
### Aliases: SparseM.hb read.matrix.hb write.matrix.hb
###   model.matrix,ANY-method model.matrix,matrix.csc.hb-method
###   model.matrix,matrix.ssc.hb-method model.matrix.matrix.ssc.hb
###   model.response,ANY-method model.response,matrix.csc.hb-method
###   model.response,matrix.ssc.hb-method model.response model.matrix
### Keywords: IO

### ** Examples

read.matrix.hb(system.file("data","lsq.rra",package = "SparseM"))-> hb.o
class(hb.o) # -> [1] "matrix.csc.hb"
model.matrix(hb.o)->X
class(X) # -> "matrix.csr"
dim(X) # -> [1] 1850  712
y <- model.response(hb.o) # extract the rhs
length(y) # [1] 1850
write.matrix.hb("lsq.out",as.matrix.csc(X),title="lsq.rra",key="WELL1850",mxtype="RRA",rhs=hb.o@rhs.ra)



