## ----echo=FALSE---------------------------------------------------------------
    knitr::opts_chunk$set(
    tidy = TRUE,
    collapse = TRUE, 
    comment = "#>")

## -----------------------------------------------------------------------------
library("HDTD")
data("VEGFmouse")
dim(VEGFmouse)
rownames(VEGFmouse)

## -----------------------------------------------------------------------------
colnames(VEGFmouse)[1:18]

## -----------------------------------------------------------------------------
meanmat.ts(VEGFmouse, N = 40, group.sizes = 9)

## -----------------------------------------------------------------------------
colnames(VEGFmouse)[1:9]
columnorder <- c(1, 4, 5, 8, 2, 3, 6, 7, 9)
VEGForder <- orderdata(VEGFmouse, N = 40, order.cols = columnorder) 
colnames(VEGForder)[1:9]

## -----------------------------------------------------------------------------
meanmat.ts(VEGForder, N = 40, group.sizes = c(4, 1, 1, 1, 1, 1))

## -----------------------------------------------------------------------------
sample_mean <- meanmat.hat(VEGFmouse, N = 40)
sample_mean

## -----------------------------------------------------------------------------
head(round(sample_mean$estmeanmat, 4), n = 10)

## -----------------------------------------------------------------------------
est_cov_mat <- covmat.hat(datamat = VEGFmouse, N = 40)
est_cov_mat

## -----------------------------------------------------------------------------
round(est_cov_mat$cols.covmat, 3)

## -----------------------------------------------------------------------------
covmat.ts(datamat = VEGFmouse, N = 40, voi = "columns")

## -----------------------------------------------------------------------------
print(citation("HDTD"), bibtex = TRUE)

