/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.function.ObjectFunction;
import cern.colt.function.ObjectObjectFunction;
import cern.colt.function.ObjectProcedure;
import cern.colt.list.IntArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.AbstractMatrix1D;
import cern.colt.matrix.objectalgo.Formatter;
import cern.colt.matrix.objectalgo.Sorting;

public abstract class ObjectMatrix1D
extends AbstractMatrix1D {
    protected ObjectMatrix1D() {
    }

    public Object aggregate(ObjectObjectFunction objectObjectFunction, ObjectFunction objectFunction) {
        if (this.size == 0) {
            return null;
        }
        Object object = objectFunction.apply(this.getQuick(this.size - 1));
        int n = this.size - 1;
        while (--n >= 0) {
            object = objectObjectFunction.apply(object, objectFunction.apply(this.getQuick(n)));
        }
        return object;
    }

    public Object aggregate(ObjectMatrix1D objectMatrix1D, ObjectObjectFunction objectObjectFunction, ObjectObjectFunction objectObjectFunction2) {
        this.checkSize(objectMatrix1D);
        if (this.size == 0) {
            return null;
        }
        Object object = objectObjectFunction2.apply(this.getQuick(this.size - 1), objectMatrix1D.getQuick(this.size - 1));
        int n = this.size - 1;
        while (--n >= 0) {
            object = objectObjectFunction.apply(object, objectObjectFunction2.apply(this.getQuick(n), objectMatrix1D.getQuick(n)));
        }
        return object;
    }

    public ObjectMatrix1D assign(Object[] objectArray) {
        if (objectArray.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + objectArray.length + ", size()=" + this.size());
        }
        int n = this.size;
        while (--n >= 0) {
            this.setQuick(n, objectArray[n]);
        }
        return this;
    }

    public ObjectMatrix1D assign(ObjectFunction objectFunction) {
        int n = this.size;
        while (--n >= 0) {
            this.setQuick(n, objectFunction.apply(this.getQuick(n)));
        }
        return this;
    }

    public ObjectMatrix1D assign(ObjectMatrix1D objectMatrix1D) {
        if (objectMatrix1D == this) {
            return this;
        }
        this.checkSize(objectMatrix1D);
        if (this.haveSharedCells(objectMatrix1D)) {
            objectMatrix1D = objectMatrix1D.copy();
        }
        int n = this.size;
        while (--n >= 0) {
            this.setQuick(n, objectMatrix1D.getQuick(n));
        }
        return this;
    }

    public ObjectMatrix1D assign(ObjectMatrix1D objectMatrix1D, ObjectObjectFunction objectObjectFunction) {
        this.checkSize(objectMatrix1D);
        int n = this.size;
        while (--n >= 0) {
            this.setQuick(n, objectObjectFunction.apply(this.getQuick(n), objectMatrix1D.getQuick(n)));
        }
        return this;
    }

    public ObjectMatrix1D assign(Object object) {
        int n = this.size;
        while (--n >= 0) {
            this.setQuick(n, object);
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = this.size;
        while (--n2 >= 0) {
            if (this.getQuick(n2) == null) continue;
            ++n;
        }
        return n;
    }

    public ObjectMatrix1D copy() {
        ObjectMatrix1D objectMatrix1D = this.like();
        objectMatrix1D.assign(this);
        return objectMatrix1D;
    }

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean bl) {
        if (!(object instanceof ObjectMatrix1D)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        ObjectMatrix1D objectMatrix1D = (ObjectMatrix1D)object;
        if (this.size != objectMatrix1D.size()) {
            return false;
        }
        if (!bl) {
            int n = this.size;
            while (--n >= 0) {
                if (this.getQuick(n) == objectMatrix1D.getQuick(n)) continue;
                return false;
            }
        } else {
            int n = this.size;
            while (--n >= 0) {
                if (this.getQuick(n) == null ? objectMatrix1D.getQuick(n) == null : this.getQuick(n).equals(objectMatrix1D.getQuick(n))) continue;
                return false;
            }
        }
        return true;
    }

    public Object get(int n) {
        if (n < 0 || n >= this.size) {
            this.checkIndex(n);
        }
        return this.getQuick(n);
    }

    protected ObjectMatrix1D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList intArrayList, ObjectArrayList objectArrayList) {
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = objectArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            objectArrayList.clear();
        }
        int n = this.size;
        int n2 = 0;
        while (n2 < n) {
            Object object = this.getQuick(n2);
            if (object != null) {
                if (bl2) {
                    intArrayList.add(n2);
                }
                if (bl) {
                    objectArrayList.add(object);
                }
            }
            ++n2;
        }
    }

    public abstract Object getQuick(int var1);

    protected boolean haveSharedCells(ObjectMatrix1D objectMatrix1D) {
        if (objectMatrix1D == null) {
            return false;
        }
        if (this == objectMatrix1D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(objectMatrix1D.getContent());
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix1D objectMatrix1D) {
        return false;
    }

    public ObjectMatrix1D like() {
        return this.like(this.size);
    }

    public abstract ObjectMatrix1D like(int var1);

    public abstract ObjectMatrix2D like2D(int var1, int var2);

    public void set(int n, Object object) {
        if (n < 0 || n >= this.size) {
            this.checkIndex(n);
        }
        this.setQuick(n, object);
    }

    public abstract void setQuick(int var1, Object var2);

    public void swap(ObjectMatrix1D objectMatrix1D) {
        this.checkSize(objectMatrix1D);
        int n = this.size;
        while (--n >= 0) {
            Object object = this.getQuick(n);
            this.setQuick(n, objectMatrix1D.getQuick(n));
            objectMatrix1D.setQuick(n, object);
        }
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        this.toArray(objectArray);
        return objectArray;
    }

    public void toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int n = this.size;
        while (--n >= 0) {
            objectArray[n] = this.getQuick(n);
        }
    }

    public String toString() {
        return new Formatter().toString(this);
    }

    protected ObjectMatrix1D view() {
        return (ObjectMatrix1D)this.clone();
    }

    public ObjectMatrix1D viewFlip() {
        return (ObjectMatrix1D)this.view().vFlip();
    }

    public ObjectMatrix1D viewPart(int n, int n2) {
        return (ObjectMatrix1D)this.view().vPart(n, n2);
    }

    public ObjectMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            int n = this.size;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        this.checkIndexes(nArray);
        int[] nArray2 = new int[nArray.length];
        int n = nArray.length;
        while (--n >= 0) {
            nArray2[n] = this.index(nArray[n]);
        }
        return this.viewSelectionLike(nArray2);
    }

    public ObjectMatrix1D viewSelection(ObjectProcedure objectProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        int n = 0;
        while (n < this.size) {
            if (objectProcedure.apply(this.getQuick(n))) {
                intArrayList.add(n);
            }
            ++n;
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements());
    }

    protected abstract ObjectMatrix1D viewSelectionLike(int[] var1);

    public ObjectMatrix1D viewSorted() {
        return Sorting.quickSort(this);
    }

    public ObjectMatrix1D viewStrides(int n) {
        return (ObjectMatrix1D)this.view().vStrides(n);
    }

    private boolean xforEach(ObjectProcedure objectProcedure) {
        int n = this.size;
        while (--n >= 0) {
            if (objectProcedure.apply(this.getQuick(n))) continue;
            return false;
        }
        return true;
    }
}

