/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.AbstractDistribution;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class Logarithmic
extends AbstractContinousDistribution {
    protected double my_p;
    private double t;
    private double h;
    private double a_prev = -1.0;
    protected static Logarithmic shared = new Logarithmic(0.5, AbstractDistribution.makeDefaultGenerator());

    public Logarithmic(double d, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(d);
    }

    public double nextDouble() {
        return this.nextDouble(this.my_p);
    }

    public double nextDouble(double d) {
        if (d != this.a_prev) {
            this.a_prev = d;
            if (d < 0.9) {
                this.t = -d / Math.log(1.0 - d);
            } else {
                this.h = Math.log(1.0 - d);
            }
        }
        double d2 = this.randomGenerator.raw();
        if (d < 0.97) {
            int n = 1;
            double d3 = this.t;
            while (d2 > d3) {
                d2 -= d3;
                d3 *= d * ((double)(++n) - 1.0) / (double)n;
            }
            return n;
        }
        if (d2 > d) {
            return 1.0;
        }
        double d4 = d2 = this.randomGenerator.raw();
        double d5 = 1.0 - Math.exp(d4 * this.h);
        if (d2 <= d5 * d5) {
            int n = (int)(1.0 + Math.log(d2) / Math.log(d5));
            return n;
        }
        if (d2 > d5) {
            return 1.0;
        }
        return 2.0;
    }

    public void setState(double d) {
        this.my_p = d;
    }

    public static double staticNextDouble(double d) {
        Logarithmic logarithmic = shared;
        synchronized (logarithmic) {
            double d2 = shared.nextDouble(d);
            return d2;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.my_p + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        Logarithmic logarithmic = shared;
        synchronized (logarithmic) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

