/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.doublealgo.Formatter;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix3D;
import corejava.Format;
import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.bin.BinFunction1D;
import hep.aida.bin.BinFunctions1D;

public class Converter {
    public double[] edges(IAxis iAxis) {
        int n = iAxis.bins();
        double[] dArray = new double[n + 1];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = iAxis.binLowerEdge(n2);
            ++n2;
        }
        dArray[n] = iAxis.upperEdge();
        return dArray;
    }

    String form(Format format, double d) {
        if (format == null || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || d != d) {
            return String.valueOf(d);
        }
        return format.form(d);
    }

    protected double[] toArrayErrors(IHistogram1D iHistogram1D) {
        int n = iHistogram1D.xAxis().bins();
        double[] dArray = new double[n];
        int n2 = n;
        while (--n2 >= 0) {
            dArray[n2] = iHistogram1D.binError(n2);
        }
        return dArray;
    }

    protected double[][] toArrayErrors(IHistogram2D iHistogram2D) {
        int n = iHistogram2D.xAxis().bins();
        int n2 = iHistogram2D.yAxis().bins();
        double[][] dArray = new double[n][n2];
        int n3 = n2;
        while (--n3 >= 0) {
            int n4 = n;
            while (--n4 >= 0) {
                dArray[n4][n3] = iHistogram2D.binError(n4, n3);
            }
        }
        return dArray;
    }

    protected double[] toArrayHeights(IHistogram1D iHistogram1D) {
        int n = iHistogram1D.xAxis().bins();
        double[] dArray = new double[n];
        int n2 = n;
        while (--n2 >= 0) {
            dArray[n2] = iHistogram1D.binHeight(n2);
        }
        return dArray;
    }

    protected double[][] toArrayHeights(IHistogram2D iHistogram2D) {
        int n = iHistogram2D.xAxis().bins();
        int n2 = iHistogram2D.yAxis().bins();
        double[][] dArray = new double[n][n2];
        int n3 = n2;
        while (--n3 >= 0) {
            int n4 = n;
            while (--n4 >= 0) {
                dArray[n4][n3] = iHistogram2D.binHeight(n4, n3);
            }
        }
        return dArray;
    }

    protected double[][][] toArrayHeights(IHistogram3D iHistogram3D) {
        int n = iHistogram3D.xAxis().bins();
        int n2 = iHistogram3D.yAxis().bins();
        int n3 = iHistogram3D.zAxis().bins();
        double[][][] dArray = new double[n][n2][n3];
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = n2;
            while (--n5 >= 0) {
                int n6 = n3;
                while (--n6 >= 0) {
                    dArray[n4][n5][n6] = iHistogram3D.binHeight(n4, n5, n6);
                }
            }
        }
        return dArray;
    }

    protected static String toString(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = dArray.length - 1;
        int n2 = 0;
        while (n2 <= n) {
            stringBuffer.append(dArray[n2]);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toString(IAxis iAxis) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Range: [" + iAxis.lowerEdge() + "," + iAxis.upperEdge() + ")");
        stringBuffer.append(", Bins: " + iAxis.bins());
        stringBuffer.append(", Bin edges: " + Converter.toString(this.edges(iAxis)) + "\n");
        return stringBuffer.toString();
    }

    public String toString(IHistogram1D iHistogram1D) {
        String string = null;
        String string2 = null;
        BinFunction1D[] binFunction1DArray = null;
        String string3 = "%G";
        Format format = new Format(string3);
        String string4 = System.getProperty("line.separator");
        int[] nArray = iHistogram1D.minMaxBins();
        String string5 = iHistogram1D.title() + ":" + string4 + "   Entries=" + this.form(format, iHistogram1D.entries()) + ", ExtraEntries=" + this.form(format, iHistogram1D.extraEntries()) + string4 + "   Mean=" + this.form(format, iHistogram1D.mean()) + ", Rms=" + this.form(format, iHistogram1D.rms()) + string4 + "   MinBinHeight=" + this.form(format, iHistogram1D.binHeight(nArray[0])) + ", MaxBinHeight=" + this.form(format, iHistogram1D.binHeight(nArray[1])) + string4 + "   Axis: " + "Bins=" + this.form(format, iHistogram1D.xAxis().bins()) + ", Min=" + this.form(format, iHistogram1D.xAxis().lowerEdge()) + ", Max=" + this.form(format, iHistogram1D.xAxis().upperEdge());
        String[] stringArray = new String[iHistogram1D.xAxis().bins()];
        int n = 0;
        while (n < iHistogram1D.xAxis().bins()) {
            stringArray[n] = this.form(format, iHistogram1D.xAxis().binLowerEdge(n));
            ++n;
        }
        String[] stringArray2 = null;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(1, iHistogram1D.xAxis().bins());
        denseDoubleMatrix2D.viewRow(0).assign(this.toArrayHeights(iHistogram1D));
        return string5 + string4 + "Heights:" + string4 + new Formatter().toTitleString(denseDoubleMatrix2D, stringArray2, stringArray, string2, string, null, binFunction1DArray);
    }

    public String toString(IHistogram2D iHistogram2D) {
        String string = "X";
        String string2 = "Y";
        BinFunction1D[] binFunction1DArray = new BinFunction1D[]{BinFunctions1D.sum};
        String string3 = "%G";
        Format format = new Format(string3);
        String string4 = System.getProperty("line.separator");
        int[] nArray = iHistogram2D.minMaxBins();
        String string5 = iHistogram2D.title() + ":" + string4 + "   Entries=" + this.form(format, iHistogram2D.entries()) + ", ExtraEntries=" + this.form(format, iHistogram2D.extraEntries()) + string4 + "   MeanX=" + this.form(format, iHistogram2D.meanX()) + ", RmsX=" + this.form(format, iHistogram2D.rmsX()) + string4 + "   MeanY=" + this.form(format, iHistogram2D.meanY()) + ", RmsY=" + this.form(format, iHistogram2D.rmsX()) + string4 + "   MinBinHeight=" + this.form(format, iHistogram2D.binHeight(nArray[0], nArray[1])) + ", MaxBinHeight=" + this.form(format, iHistogram2D.binHeight(nArray[2], nArray[3])) + string4 + "   xAxis: " + "Bins=" + this.form(format, iHistogram2D.xAxis().bins()) + ", Min=" + this.form(format, iHistogram2D.xAxis().lowerEdge()) + ", Max=" + this.form(format, iHistogram2D.xAxis().upperEdge()) + string4 + "   yAxis: " + "Bins=" + this.form(format, iHistogram2D.yAxis().bins()) + ", Min=" + this.form(format, iHistogram2D.yAxis().lowerEdge()) + ", Max=" + this.form(format, iHistogram2D.yAxis().upperEdge());
        String[] stringArray = new String[iHistogram2D.xAxis().bins()];
        int n = 0;
        while (n < iHistogram2D.xAxis().bins()) {
            stringArray[n] = this.form(format, iHistogram2D.xAxis().binLowerEdge(n));
            ++n;
        }
        Object[] objectArray = new String[iHistogram2D.yAxis().bins()];
        int n2 = 0;
        while (n2 < iHistogram2D.yAxis().bins()) {
            objectArray[n2] = this.form(format, iHistogram2D.yAxis().binLowerEdge(n2));
            ++n2;
        }
        new ObjectArrayList(objectArray).reverse();
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(this.toArrayHeights(iHistogram2D));
        doubleMatrix2D = doubleMatrix2D.viewDice().viewRowFlip();
        return string5 + string4 + "Heights:" + string4 + new Formatter().toTitleString(doubleMatrix2D, (String[])objectArray, stringArray, string2, string, null, binFunction1DArray);
    }

    public String toString(IHistogram3D iHistogram3D) {
        String string = "X";
        String string2 = "Y";
        String string3 = "Z";
        BinFunction1D[] binFunction1DArray = new BinFunction1D[]{BinFunctions1D.sum};
        String string4 = "%G";
        Format format = new Format(string4);
        String string5 = System.getProperty("line.separator");
        int[] nArray = iHistogram3D.minMaxBins();
        String string6 = iHistogram3D.title() + ":" + string5 + "   Entries=" + this.form(format, iHistogram3D.entries()) + ", ExtraEntries=" + this.form(format, iHistogram3D.extraEntries()) + string5 + "   MeanX=" + this.form(format, iHistogram3D.meanX()) + ", RmsX=" + this.form(format, iHistogram3D.rmsX()) + string5 + "   MeanY=" + this.form(format, iHistogram3D.meanY()) + ", RmsY=" + this.form(format, iHistogram3D.rmsX()) + string5 + "   MeanZ=" + this.form(format, iHistogram3D.meanZ()) + ", RmsZ=" + this.form(format, iHistogram3D.rmsZ()) + string5 + "   MinBinHeight=" + this.form(format, iHistogram3D.binHeight(nArray[0], nArray[1], nArray[2])) + ", MaxBinHeight=" + this.form(format, iHistogram3D.binHeight(nArray[3], nArray[4], nArray[5])) + string5 + "   xAxis: " + "Bins=" + this.form(format, iHistogram3D.xAxis().bins()) + ", Min=" + this.form(format, iHistogram3D.xAxis().lowerEdge()) + ", Max=" + this.form(format, iHistogram3D.xAxis().upperEdge()) + string5 + "   yAxis: " + "Bins=" + this.form(format, iHistogram3D.yAxis().bins()) + ", Min=" + this.form(format, iHistogram3D.yAxis().lowerEdge()) + ", Max=" + this.form(format, iHistogram3D.yAxis().upperEdge()) + string5 + "   zAxis: " + "Bins=" + this.form(format, iHistogram3D.zAxis().bins()) + ", Min=" + this.form(format, iHistogram3D.zAxis().lowerEdge()) + ", Max=" + this.form(format, iHistogram3D.zAxis().upperEdge());
        String[] stringArray = new String[iHistogram3D.xAxis().bins()];
        int n = 0;
        while (n < iHistogram3D.xAxis().bins()) {
            stringArray[n] = this.form(format, iHistogram3D.xAxis().binLowerEdge(n));
            ++n;
        }
        Object[] objectArray = new String[iHistogram3D.yAxis().bins()];
        int n2 = 0;
        while (n2 < iHistogram3D.yAxis().bins()) {
            objectArray[n2] = this.form(format, iHistogram3D.yAxis().binLowerEdge(n2));
            ++n2;
        }
        new ObjectArrayList(objectArray).reverse();
        Object[] objectArray2 = new String[iHistogram3D.zAxis().bins()];
        int n3 = 0;
        while (n3 < iHistogram3D.zAxis().bins()) {
            objectArray2[n3] = this.form(format, iHistogram3D.zAxis().binLowerEdge(n3));
            ++n3;
        }
        new ObjectArrayList(objectArray2).reverse();
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(this.toArrayHeights(iHistogram3D));
        doubleMatrix3D = doubleMatrix3D.viewDice(2, 1, 0).viewSliceFlip().viewRowFlip();
        return string6 + string5 + "Heights:" + string5 + new Formatter().toTitleString(doubleMatrix3D, (String[])objectArray2, (String[])objectArray, stringArray, string3, string2, string, "", binFunction1DArray);
    }

    public String toXML(IHistogram1D iHistogram1D) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        stringBuffer.append(string);
        stringBuffer.append("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
        stringBuffer.append(string);
        stringBuffer.append("<plotML>");
        stringBuffer.append(string);
        stringBuffer.append("<plot>");
        stringBuffer.append(string);
        stringBuffer.append("<dataArea>");
        stringBuffer.append(string);
        stringBuffer.append("<data1d>");
        stringBuffer.append(string);
        stringBuffer.append("<bins1d title=\"" + iHistogram1D.title() + "\">");
        stringBuffer.append(string);
        int n = 0;
        while (n < iHistogram1D.xAxis().bins()) {
            stringBuffer.append(iHistogram1D.binEntries(n) + "," + iHistogram1D.binError(n));
            stringBuffer.append(string);
            ++n;
        }
        stringBuffer.append("</bins1d>");
        stringBuffer.append(string);
        stringBuffer.append("<binnedDataAxisAttributes type=\"double\" axis=\"x0\"");
        stringBuffer.append(" min=\"" + iHistogram1D.xAxis().lowerEdge() + "\"");
        stringBuffer.append(" max=\"" + iHistogram1D.xAxis().upperEdge() + "\"");
        stringBuffer.append(" numberOfBins=\"" + iHistogram1D.xAxis().bins() + "\"");
        stringBuffer.append("/>");
        stringBuffer.append(string);
        stringBuffer.append("<statistics>");
        stringBuffer.append(string);
        stringBuffer.append("<statistic name=\"Entries\" value=\"" + iHistogram1D.entries() + "\"/>");
        stringBuffer.append(string);
        stringBuffer.append("<statistic name=\"Underflow\" value=\"" + iHistogram1D.binEntries(-2) + "\"/>");
        stringBuffer.append(string);
        stringBuffer.append("<statistic name=\"Overflow\" value=\"" + iHistogram1D.binEntries(-1) + "\"/>");
        stringBuffer.append(string);
        if (!Double.isNaN(iHistogram1D.mean())) {
            stringBuffer.append("<statistic name=\"Mean\" value=\"" + iHistogram1D.mean() + "\"/>");
            stringBuffer.append(string);
        }
        if (!Double.isNaN(iHistogram1D.rms())) {
            stringBuffer.append("<statistic name=\"RMS\" value=\"" + iHistogram1D.rms() + "\"/>");
            stringBuffer.append(string);
        }
        stringBuffer.append("</statistics>");
        stringBuffer.append(string);
        stringBuffer.append("</data1d>");
        stringBuffer.append(string);
        stringBuffer.append("</dataArea>");
        stringBuffer.append(string);
        stringBuffer.append("</plot>");
        stringBuffer.append(string);
        stringBuffer.append("</plotML>");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String toXML(IHistogram2D iHistogram2D) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        stringBuffer.append(string);
        stringBuffer.append("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
        stringBuffer.append(string);
        stringBuffer.append("<plotML>");
        stringBuffer.append(string);
        stringBuffer.append("<plot>");
        stringBuffer.append(string);
        stringBuffer.append("<dataArea>");
        stringBuffer.append(string);
        stringBuffer.append("<data2d type=\"xxx\">");
        stringBuffer.append(string);
        stringBuffer.append("<bins2d title=\"" + iHistogram2D.title() + "\" xSize=\"" + iHistogram2D.xAxis().bins() + "\" ySize=\"" + iHistogram2D.yAxis().bins() + "\">");
        stringBuffer.append(string);
        int n = 0;
        while (n < iHistogram2D.xAxis().bins()) {
            int n2 = 0;
            while (n2 < iHistogram2D.yAxis().bins()) {
                stringBuffer.append(iHistogram2D.binEntries(n, n2) + "," + iHistogram2D.binError(n, n2));
                stringBuffer.append(string);
                ++n2;
            }
            ++n;
        }
        stringBuffer.append("</bins2d>");
        stringBuffer.append(string);
        stringBuffer.append("<binnedDataAxisAttributes type=\"double\" axis=\"x0\"");
        stringBuffer.append(" min=\"" + iHistogram2D.xAxis().lowerEdge() + "\"");
        stringBuffer.append(" max=\"" + iHistogram2D.xAxis().upperEdge() + "\"");
        stringBuffer.append(" numberOfBins=\"" + iHistogram2D.xAxis().bins() + "\"");
        stringBuffer.append("/>");
        stringBuffer.append(string);
        stringBuffer.append("<binnedDataAxisAttributes type=\"double\" axis=\"y0\"");
        stringBuffer.append(" min=\"" + iHistogram2D.yAxis().lowerEdge() + "\"");
        stringBuffer.append(" max=\"" + iHistogram2D.yAxis().upperEdge() + "\"");
        stringBuffer.append(" numberOfBins=\"" + iHistogram2D.yAxis().bins() + "\"");
        stringBuffer.append("/>");
        stringBuffer.append(string);
        stringBuffer.append("</data2d>");
        stringBuffer.append(string);
        stringBuffer.append("</dataArea>");
        stringBuffer.append(string);
        stringBuffer.append("</plot>");
        stringBuffer.append(string);
        stringBuffer.append("</plotML>");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

