/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.dist.GapDistribution;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.symbol.Alphabet;

public final class MagicalState
extends SimpleEmissionState {
    private static final Map stateCache = new HashMap();
    private static final Map symbolCache = new HashMap();

    private MagicalState(Alphabet alphabet, int n) {
        super("!-" + n, Annotation.EMPTY_ANNOTATION, new int[n], new GapDistribution(alphabet));
        int[] nArray = this.getAdvance();
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = 1;
            ++n2;
        }
    }

    public static MagicalState getMagicalState(Alphabet alphabet, int n) {
        AlphaHeads alphaHeads = new AlphaHeads(alphabet, n);
        MagicalState magicalState = (MagicalState)stateCache.get(alphaHeads);
        if (magicalState == null) {
            magicalState = new MagicalState(alphabet, n);
            stateCache.put(alphaHeads, magicalState);
        }
        return magicalState;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new PlaceHolder(this.getDistribution().getAlphabet(), this.getAdvance().length);
    }

    private static class AlphaHeads {
        public Alphabet alpha;
        public int heads;

        public AlphaHeads(Alphabet alphabet, int n) {
            this.alpha = alphabet;
            this.heads = n;
        }

        public boolean equals(Object object) {
            AlphaHeads alphaHeads = (AlphaHeads)object;
            return this.alpha == alphaHeads.alpha && this.heads == alphaHeads.heads;
        }

        public int hashCode() {
            return this.alpha.hashCode() ^ this.heads;
        }
    }

    private static class PlaceHolder
    implements Serializable {
        private Alphabet alpha;
        private int heads;

        public PlaceHolder(Alphabet alphabet, int n) {
            this.alpha = alphabet;
            this.heads = n;
        }

        public Object readResolve() throws ObjectStreamException {
            return MagicalState.getMagicalState(this.alpha, this.heads);
        }
    }
}

