/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SubSequence
implements Sequence {
    private Sequence parent;
    private SymbolList symbols;
    private FeatureHolder features;
    private String name;
    private String uri;
    private Annotation annotation;
    protected transient ChangeSupport changeSupport;
    private transient ChangeListener forwarder;

    public SubSequence(Sequence sequence, int n, int n2) {
        this.parent = sequence;
        this.symbols = sequence.subList(n, n2);
        FeatureFilter.OverlapsLocation overlapsLocation = new FeatureFilter.OverlapsLocation(new RangeLocation(n, n2));
        this.features = new ProjectedFeatureHolder(sequence, overlapsLocation, this, 1 - n, false);
        this.name = String.valueOf(sequence.getName()) + " (" + n + " - " + n2 + ")";
        this.uri = String.valueOf(sequence.getURN()) + "?start=" + n + ";end=" + n2;
        this.annotation = sequence.getAnnotation();
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeSupport == null) {
            this.allocChangeSupport();
        }
        this.changeSupport.addChangeListener(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        if (this.changeSupport == null) {
            this.allocChangeSupport();
        }
        this.changeSupport.addChangeListener(changeListener, changeType);
    }

    protected void allocChangeSupport() {
        this.changeSupport = new ChangeSupport();
        this.forwarder = new ChangeListener(){

            public void postChange(ChangeEvent changeEvent) {
                if (SubSequence.this.changeSupport != null) {
                    SubSequence.this.changeSupport.firePostChangeEvent(new ChangeEvent(this, changeEvent.getType(), changeEvent.getChange(), changeEvent.getPrevious(), changeEvent));
                }
            }

            public void preChange(ChangeEvent changeEvent) throws ChangeVetoException {
                if (SubSequence.this.changeSupport != null) {
                    SubSequence.this.changeSupport.firePreChangeEvent(new ChangeEvent(this, changeEvent.getType(), changeEvent.getChange(), changeEvent.getPrevious(), changeEvent));
                }
            }
        };
        this.symbols.addChangeListener(this.forwarder);
        this.features.addChangeListener(this.forwarder);
    }

    public boolean containsFeature(Feature feature) {
        return this.features.containsFeature(feature);
    }

    public int countFeatures() {
        return this.features.countFeatures();
    }

    public Feature createFeature(Feature.Template template) throws ChangeVetoException {
        throw new ChangeVetoException("Can't add features to subsequences");
    }

    public void edit(Edit edit) throws ChangeVetoException {
        throw new ChangeVetoException("Can't edit SubSequences");
    }

    public Iterator features() {
        return this.features.features();
    }

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        return this.features.filter(featureFilter, bl);
    }

    public Alphabet getAlphabet() {
        return this.symbols.getAlphabet();
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public String getName() {
        return this.name;
    }

    public Sequence getParent() {
        return this.parent;
    }

    public String getURN() {
        return this.uri;
    }

    public Iterator iterator() {
        return this.symbols.iterator();
    }

    public int length() {
        return this.symbols.length();
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removeChangeListener(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        if (this.changeSupport != null) {
            this.changeSupport.removeChangeListener(changeListener, changeType);
        }
    }

    public void removeFeature(Feature feature) throws ChangeVetoException {
        throw new ChangeVetoException("Can't remove features from subsequences");
    }

    public String seqString() {
        return this.symbols.seqString();
    }

    public SymbolList subList(int n, int n2) {
        return this.symbols.subList(n, n2);
    }

    public String subStr(int n, int n2) {
        return this.symbols.subStr(n, n2);
    }

    public Symbol symbolAt(int n) {
        return this.symbols.symbolAt(n);
    }

    public List toList() {
        return this.symbols.toList();
    }
}

