/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bridge.Biocorba.Seqcore;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.Biocorba.Seqcore.PrimarySeq;
import org.Biocorba.Seqcore.PrimarySeqDB;
import org.Biocorba.Seqcore.PrimarySeqIterator;
import org.Biocorba.Seqcore.SeqDB;
import org.Biocorba.Seqcore.UnableToProcess;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bridge.Biocorba.Seqcore.SequenceAdapter;
import org.biojava.bridge.Biocorba.Seqcore.SequenceIteratorAdapter;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SequenceDBAdapter
implements SequenceDB {
    private PrimarySeqDB primarySeqDB;

    public SequenceDBAdapter(PrimarySeqDB primarySeqDB) {
        this.primarySeqDB = primarySeqDB;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void addSequence(Sequence sequence) throws ChangeVetoException {
        throw new ChangeVetoException("SequenceDBAdapter is immutable");
    }

    public String getName() {
        return this.getPrimarySeqDB().database_name();
    }

    public PrimarySeqDB getPrimarySeqDB() {
        return this.primarySeqDB;
    }

    public Sequence getSequence(String string) throws BioException {
        try {
            PrimarySeq primarySeq = this.getPrimarySeqDB().get_PrimarySeq(string);
            return new SequenceAdapter(primarySeq);
        }
        catch (UnableToProcess unableToProcess) {
            throw new BioException((Throwable)((Object)unableToProcess), "Could not retrieve sequence from CORBA database " + this.getPrimarySeqDB().database_name());
        }
        catch (IllegalAlphabetException illegalAlphabetException) {
            throw new BioException(illegalAlphabetException, "Unable to create SequenceAdapter");
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioException(illegalSymbolException, "Unable to create SequenceAdapter");
        }
        catch (BioException bioException) {
            throw new BioException(bioException, "Unable to create SequenceAdapter");
        }
    }

    public Set ids() {
        PrimarySeqDB primarySeqDB = this.getPrimarySeqDB();
        if (primarySeqDB instanceof SeqDB) {
            String[] stringArray = ((SeqDB)primarySeqDB).get_primaryidList();
            HashSet<String> hashSet = new HashSet<String>();
            int n = 0;
            while (n < stringArray.length) {
                hashSet.add(stringArray[n]);
                ++n;
            }
            return hashSet;
        }
        return Collections.EMPTY_SET;
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void removeSequence(String string) throws ChangeVetoException {
        throw new ChangeVetoException("SequenceDBAdapter is immutable");
    }

    public SequenceIterator sequenceIterator() {
        PrimarySeqIterator primarySeqIterator = this.getPrimarySeqDB().make_PrimarySeqIterator();
        return new SequenceIteratorAdapter(primarySeqIterator);
    }
}

