/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.util.Iterator;
import java.util.Set;
import org.biojava.stats.svm.ItemValue;
import org.biojava.stats.svm.SVMClassifierModel;
import org.biojava.stats.svm.SVMKernel;

public abstract class AbstractSVMClassifierModel
implements SVMClassifierModel {
    public void addItem(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("addItem not supported by " + this.getClass());
    }

    public void addItemAlpha(Object object, double d) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("addItemAlpha not supported by " + this.getClass());
    }

    public double classify(Object object) {
        double d = 0.0;
        SVMKernel sVMKernel = this.getKernel();
        double d2 = this.getThreshold();
        Iterator iterator = this.itemAlphas().iterator();
        while (iterator.hasNext()) {
            ItemValue itemValue = (ItemValue)iterator.next();
            double d3 = itemValue.getValue();
            if (d3 == 0.0) continue;
            d += d3 * sVMKernel.evaluate(itemValue.getItem(), object);
        }
        return d - d2;
    }

    public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("clear not supported by " + this.getClass());
    }

    public abstract double getAlpha(Object var1);

    public abstract SVMKernel getKernel();

    public abstract double getThreshold();

    public abstract Set itemAlphas();

    public abstract Set items();

    public void removeItem(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("removeItem not supported by " + this.getClass());
    }

    public void setAlpha(Object object, double d) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setAlpha not supported by " + this.getClass());
    }

    public void setThreshold() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setThreshold not supported by " + this.getClass());
    }

    public abstract void setThreshold(double var1) throws UnsupportedOperationException;
}

