/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import org.biojava.stats.svm.NestedKernel;
import org.biojava.stats.svm.SVMKernel;

public class PolynomialKernel
extends NestedKernel {
    private double order;
    private double a;
    private double c;

    public PolynomialKernel() {
        this(null, 3.0, 1.0, 1.0);
    }

    public PolynomialKernel(SVMKernel sVMKernel, double d, double d2, double d3) {
        super(sVMKernel);
        this.order = d;
        this.a = d2;
        this.c = d3;
    }

    public double evaluate(Object object, Object object2) {
        return Math.pow(this.getMultiplier() * this.getNestedKernel().evaluate(object, object2) + this.getConstant(), this.getOrder());
    }

    public double getConstant() {
        return this.c;
    }

    public double getMultiplier() {
        return this.a;
    }

    public double getOrder() {
        return this.order;
    }

    public void setConstant(double d) {
        this.c = d;
    }

    public void setMultiplier(double d) {
        this.a = d;
    }

    public void setOrder(double d) {
        this.order = d;
    }

    public String toString() {
        return "Polynomial kernel K(x, y | k) = (" + this.getMultiplier() + " * k(x, y) + " + this.c + ")^" + this.order + ". k = " + this.getNestedKernel().toString();
    }
}

