\name{GOGO2LL}
\alias{GOGO2LL}
\title{Annotation of GO identifiers by the corresponding LocusLink
  identifiers} 
\description{
This is an R environment (hash table) mapping GO ids to the LocusLink
ids corresponding to the GO id. 
}
\details{
  GO ids are Keys and the corresponding LocusLink ids are values. Values
  are named vectors of length 1 or greater depending on whether a given
  GO id can be mapped to only one or more LocusLink ids. Names for
  values are the evidence codes for the GO id (if evidence code was
  provided by source data). The evidence codes that are in use include:

  IMP - inferred from mutant phenotype  

  IGI - inferred from genetic interaction

  IPI - inferred from physical interaction  

  ISS - inferred from sequence similarity  

  IDA - inferred from direct assay  

  IEP - inferred from expression pattern  

  IEA - inferred from electronic annotation  

  TAS - traceable author statement  

  NAS - non-traceable author statement  

  ND - no biological data available  

  IC - inferred by curator

  NA is assigned to GO ids that can not be mapped to any LocusLink id at
  this time.  

  Only specific mappings (not derived from the directed acyclic graph of 
  Gene Ontology) between GO and LocusLink ids were included. Non-specific 
  mappings (derived from the directed acyclic graph of Gene Ontology. 
  e. g. GO ids are mapped to LocusLink ids that are mapped to their 
  children) are provided by a separate environment named GOALLLL. 

  Mappings were based on data provided by:

  #GOSOURCE#

  #LLSOURCE#

  Package built: #DATE#
}
\references{
  \url{http://www.geneontology.org/} and
\url{http://www.ncbi.nlm.nih.gov/LocusLink} 
}
\examples{
    require("GO") || stop("GO unavailable")
    # Convert the environment object to a list
    xx <- as.list(GOGO2LL)
    # Remove GO ids that are not mapped to any LocusLink id
    xx <- xx[!is.na(xx)]
    if(length(xx) > 0){
        # Get the LocusLink ids for the first two elents of xx
        llids  <- xx[1:2]
        # Get the evidence code llids
        evds <- sapply(llids, names)
    }

}
\keyword{datasets}

