\name{GOTERM}
\alias{GOTERM}
\title{Annotation of GO identifiers by terms defined by Gene Ontology
  Consortium}
\description{
This is an R environment (hash table) mapping GO ids to the specific
terms in defined by Gene Ontology Consortium
}
\details{
  GO ids are keys and the corresponding GO terms are values. Each value
  is a GOTerms object with 6 slots (GOID - GO identifier, Term - the
  specific GO ontology term for the GO id, Synonym - other synonymous
  terms, Secondary - secondary GO ids that were merged to the primary GO
  id, Definition - further definition of the GO ontology term, Category
  - the GO ontology category. Can be MF - molecular function, CC -
  cellular component, or BP - biological process).

  All the obsolete GO terms are under the nodes "obsolete molecular
  function" (GO:0008369), "obsolete cellular component" (GO id
  GO:0008370), and "obsolete biological process" (GO:0008371). Each of
  these GO ids has a group of GO ids as their direct children (nodes
  directly linked to but below the GO ids along the directed acyclic
  graph defined by GO) with GO terms that were defined by GO but are
  deprecated in the current build. These deprecated GO terms were
  appended by "(obsolete)" when the data package was built. 

  Mappings were based on data provided by:

  #GOSOURCE#

  Package built: #DATE#
}
\references{
  \url{http://www.ncbi.nlm.nih.gov/LocusLink} 
}
\examples{
    require("GO") || stop("GO unavailable")
    require("annotate") || stop("annotate unavailable")
    # Convert the environment object to a list
    xx <- as.list(GOTERM)
    if(length(xx) > 0){
        # Get the TERMS for the first elent of xx
        GOID(xx[[1]])
        Term(xx[[1]])
        Synonym(xx[[1]])
        Secondary(xx[[1]])
        Definition(xx[[1]])
        Category(xx[[1]])
    }
}
\keyword{datasets}

