\name{#PKGNAME#LL2HGID}
\alias{#PKGNAME#LL2HGID}
\alias{#PKGNAME#ACC2HGID}
\alias{#PKGNAME#HGID2LL}
\alias{#PKGNAME#HGID2ACC} 
\title{Mappings between public database ids and NCBI's Internal
  HomoloGeneIDs for #ORGANISM#}  
\description{
  Provides mappings between public database ids and internal
  HomoloGeneIDs (HGID) used by NCBI to represent sequences for
  #ORGANISM#. Public database ids include LocusLink ids (LL) and GenBank
  Accesion/RefSeq numbers (ACC).     
}
\details{
  Each object is an environment object with key and value pairs. Keys
  are ids specified by the abbreviation proceeding the number 2 of the
  name of an object (e.g. LL in #PKGNAME#LL2HGID) and values are ids
  specified by the abbreviation following the number 2 (e.g. HGID in
  #PKGNAME#LL2HGID). Values may be vectors of length 1 or greater depending
  on whether a key id can be mapped to only one or more other
  ids. Vector names are the code used by NCBI for various organism.

  #PKGNAME#LL2HGID or #PKGNAME#ACC2HGID can be used to find the
  HomoloGeneIDs for a give LocusLink id or GenBank/RefSeq accession
  number and then the data for homologous genes found in other
  organisms.  
  
  Mappings contained were based on data provided by HomoloGene.
  
  #HGSOURCE#

  Packagebuilt #DATE#
}
\references{
\url{http://www.ncbi.nih.gov/entrez/query.fcgi?db=homologene}
}
\examples{
    require("annotate") || stop("annotate unavailable")
    xx <- as.list(#PKGNAME#LL2HGID)
        if(length(xx) > 5){
                # Get the value of the first key
                xx[2]
                # Get the value for a few keys
                if(length(xx) >= 3){
                        xx[2:4]
                }
        }
}
\keyword{datasets} 

