### Name: GOXMLParser
### Title: Functions to read/parse the XML document of Gene Ontology data
### Aliases: GOXMLParser getChildNodes getOffspringNodes getParentNodes
###   getAncestors getTopGOid mapGO2Category getGOGroupIDs mapGO2AllProbe
### Keywords: manip

### ** Examples


# Create the XML doc
  cat(paste("<?xml version='1.0'?>",
         "<!-- A test file for the examples in GOXMLParser.R Doc -->",
         "<go>",            
             "<go:term>",
                 "<go:accession>GO:0003674</go:accession>",
                 "<go:name>molecular_function</go:name>",
                 "<go:is_a rdf='http://wwww.myurl.org/go#GO:0003673' />",
                 "<go:part_of rdf = 'http://wwww.myurl.org/go#GO:0003672' />",
             "</go:term>",
             "<go:term>",
                 "<go:accession>GO:0005575</go:accession>",
                 "<go:name>cellular_cpmponent</go:name>",
                 "<go:is_a rdf= 'http://wwww.myurl.org/go#GO:0003673'/>",
                 "<go:part_of rdf = 'http://wwww.myurl.org/go#GO:0003674' />",
             "</go:term>",
          "</go>"), file = "testDoc")

  # Parse the dummy file using GOXMLParser 
  goData <- GOXMLParser("testDoc")
  # Get the child nodes for a GO id
  getChildNodes("GO:0003674", goData)
  getOffspringNodes("GO:0003673", goData, FALSE)
  getParentNodes("GO:0005575", goData)
  getAncestors("GO:0005575", goData, ";", FALSE, "GO:0003674")
  getTopGOid("GO")
  unlink("testDoc")



