### Name: GOCCPARENTS
### Title: Annotation of GO identifiers by the GO identifiers of their
###   direct parents
### Aliases: GOCCPARENTS
### Keywords: datasets

### ** Examples

  require("GO", character.only = TRUE) || stop("GO unavailable")
  require("annotate", character.only = TRUE) || stop("annoate unavailable")
  # Convert the environment object to a list
  xx <- as.list(GOCCPARENTS)
  # Remove GO ids that do not have any parent
  xx <- xx[!is.na(xx)]
  if(length(xx) > 0){
     goids <- xx[[1]]
     # Find out the GO terms for the first parent goid
     GOID(GOTERM[[goids[1]]])
     Term(GOTERM[[goids[1]]])
     Synonym(GOTERM[[goids[1]]])
     Secondary(GOTERM[[goids[1]]])
     Definition(GOTERM[[goids[1]]])
  }



