### Name: fdc
### Title: FDC (false discovery count)
### Aliases: fdc
### Keywords: math

### ** Examples

   ## data matrix: 2000 genes, 16 samples
   x  <- matrix(runif(2000*16), ncol=16)
   ## 8 blue and 8 red samples
   fac <- factor(c(rep("blue", 8), rep("red", 8)))
   ## implant differential signal into the first 50 genes
   x[1:50, fac=="blue"] <- x[1:50, fac=="blue"] + 1

   res <- fdc(x, fac)
   plot(res$nrgenesel, res$fdc, pch=16, col="blue",
       xlab="Number of genes selected",
       ylab="Expected number of false discoveries")
   abline(a=0, b=1, col="red", lwd=2)

   qqplot(res$stat, res$mpstat, pch=".")
   abline(a=0, b=1, col="red", lwd=2)




