### Name: identifyLines
### Title: A function for identifying sample lines on an alongChrom() plot.
### Aliases: identifyLines
### Keywords: utilities

### ** Examples

   data(eset)

   ## A bit of a hack to not have a package dependency on hgu95av2
   ## but need to fiddle w/ the warn level to not fail the example anyways.
   curWarn <- options(warn=0)
   on.exit(options(warn=curWarn), add=TRUE)
   if (require(hgu95av2)) {
     z <- buildChromLocation("hgu95av2")
     lty <- c(1, 2, 3, 4, 5)
     cols <- c("red", "green", "blue", "orange", "magenta", "black")
     identEnv <- alongChrom(eset,"1", z, xloc="equispaced",
                          plotFormat="cumulative", scale="none",
                          lty,cols)
     if (interactive()) {
       identifyLines(identEnv)
     }
  } else print("This example needs the hgu95av2 data package")



