### Name: Defaults.Mclust
### Title: List of values controlling defaults for some MCLUST functions.
### Aliases: Defaults.Mclust .Mclust
### Keywords: cluster

### ** Examples

n <- 250 ## create artificial data
set.seed(0)
x <- rbind(matrix(rnorm(n*2), n, 2) %*% diag(c(1,9)),
           matrix(rnorm(n*2), n, 2) %*% diag(c(1,9))[,2:1])
xclass <- c(rep(1,n),rep(2,n))
odd <- seq(1, 2*n, 2)
train <- mclustDAtrain(x[odd, ], labels = xclass[odd]) ## training step
even <- odd + 1
test <- mclustDAtest(x[even, ], train) ## compute model densities

data(iris)
irisMatrix <- iris[,1:4]
irisClass <- iris[,5]

.Mclust
.Mclust <- mclustOptions(tol = 1.e-6, emModelNames = c("VII", "VVI", "VVV"))
.Mclust
irisBic <- EMclust(irisMatrix)
summary(irisBic, irisMatrix)
.Mclust <- mclustOptions() # restore defaults
.Mclust



