### Name: sim
### Title: Simulate from Parameterized MVN Mixture Models
### Aliases: sim
### Keywords: cluster

### ** Examples

data(iris)
irisMatrix <- as.matrix(iris[,1:4])

irisBic <- EMclust(irisMatrix)
irisSumry <- summary(irisBic,irisMatrix)
names(irisSumry)
irisSim <- sim(modelName = irisSumry$modelName, n = dim(irisMatrix)[1],
       mu = irisSumry$mu, decomp = irisSumry$decomp, pro = irisSumry$pro)
## Not run: 
##D irisSim <- do.call("sim", irisSumry) ## alternative call
## End(Not run)

par(pty = "s", mfrow = c(1,2))
dimens <- c(1,2)
xlim <- range(rbind(irisMatrix,irisSim)[,dimens][,1])
ylim <- range(rbind(irisMatrix,irisSim)[,dimens][,2])

cl <- irisSumry$classification
coordProj(irisMatrix, par=irisSumry, classification=cl, dimens=dimens, 
          xlim=xlim, ylim=ylim)
cl <- attr(irisSim,"classification")
coordProj(irisSim, par=irisSumry, classification=cl, dimens=dimens, 
          xlim=xlim, ylim=ylim)

irisSumry3 <- summary(irisBic,irisMatrix, G=3)
irisSim3 <- do.call("sim", c(list(n = 500, seed = 1), irisSumry3))
clPairs(irisSim3, cl = attr(irisSim3,"classification"))



