## ----echo=TRUE----------------------------------------------------------------
htmltools::img(
    src=knitr::image_uri("cypress_official.png"),
    alt="logo",
    style="position:absolute; top:0; right:0; padding:10px; height:280px"
)

## ----eval=FALSE, warning=FALSE, message=FALSE---------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# BiocManager::install("cypress")

## ----eval=FALSE,warning=FALSE,message=FALSE-----------------------------------
# library(cypress)
# vignette("cypress")

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
library(cypress)
library(BiocParallel)
data(ASD_prop_se)
result1 <- simFromData(INPUTdata=ASD_prop, #SummarizedExperiment object.
                      CT_index=(seq_len(6) + 2), #Column index for cell types proportion matrix.
                      CT_unk=FALSE, #CT_unk should be True if no cell type proportion matrix.
                      n_sim=2, #Total number of iterations users wish to conduct.
                      n_gene=1000,  #Total number of genetic features users with to conduct.
                      DE_pct=0.05, #Percentage of DEG on each cell type.
                      ss_group_set=c(8,10), #Sample sizes per group users wish to simulate.
                      lfc_set=c(1,1.5), #Effect sizes users wish to simulate
                      DEmethod = "TOAST" # DE methods we used
                      )

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
library(cypress)
data(quickPowerGSE60424)
result2<-quickPower(data="IAD") # Options include 'IAD', 'IBD', or 'ASD'.

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
### plot statistical power results
plotPower(simulation_results=result2,# Simulation results generated by quickPower() or simFromData()
          effect.size=1,# A numerical value indicating which effect size is to be fixed.
          sample_size=10 )# A numerical value indicating which sample size to be fixed.

### plot TDR results
plotTDR(simulation_results=result2,  
        effect.size=1,                
        sample_size=10)    

### plot FDC results
plotFDC(simulation_results=result2,  
        sample_size=10)              


## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
data(ASD_prop_se)
ASD_prop

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
data(ASD_prop_se)
result1 <- simFromData(INPUTdata=ASD_prop,  
                      CT_index=(seq_len(6)+2), CT_unk=FALSE,
                      n_sim=2,n_gene=1000,DE_pct=0.05,
                      ss_group_set=c(8,10),
                      lfc_set=c(1, 1.5))


## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
data(quickParaGSE60424)
result2 <- simFromParam(sim_param="IAD",   #Options for 'IAD','ASD' and 'IBD'
                       n_sim=2,DE_pct=0.05,n_gene=1000,
                       ss_group_set=c(8, 10),lfc_set=c(1, 1.5),
                       lfc_target=0.5, fdr_thred=0.1)

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
data(quickPowerGSE60424)
quickPower<-quickPower(data="IAD") ###Options include 'IAD', 'IBD', or 'ASD'.

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
### plot statistical power results
plotPower(simulation_results=quickPower,effect.size=1,sample_size=10 )

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
### plot TDR results
plotTDR(simulation_results=quickPower,effect.size=1,sample_size=10)

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
### plot FDC results
plotFDC(simulation_results=quickPower,sample_size=10)

## ----sessionInfo, echo=FALSE--------------------------------------------------
sessionInfo()

