/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.item.ColorFill;
import edu.rit.draw.item.Fill;
import edu.rit.draw.item.Outline;
import edu.rit.draw.item.SolidOutline;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RoundSolidOutline
implements Outline {
    public static final float NORMAL_WIDTH = 1.0f;
    public static final Fill NORMAL_FILL = ColorFill.BLACK;
    public static final SolidOutline NORMAL_OUTLINE = new SolidOutline();
    private static final long serialVersionUID = 1745881594692371221L;
    private float myWidth;
    private Fill myFill;
    private transient BasicStroke myStroke;

    public RoundSolidOutline() {
        this.myWidth = 1.0f;
        this.myFill = NORMAL_FILL;
        this.computeStroke();
    }

    public RoundSolidOutline(RoundSolidOutline roundSolidOutline) {
        this.myWidth = roundSolidOutline.myWidth;
        this.myFill = roundSolidOutline.myFill;
        this.computeStroke();
    }

    public float width() {
        return this.myWidth;
    }

    public RoundSolidOutline width(float f) {
        if ((double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.myWidth = f;
        this.computeStroke();
        return this;
    }

    public Fill fill() {
        return this.myFill;
    }

    public RoundSolidOutline fill(Fill fill) {
        if (fill == null) {
            throw new NullPointerException();
        }
        this.myFill = fill;
        this.computeStroke();
        return this;
    }

    public float getStrokeWidth() {
        return this.myWidth;
    }

    public void setGraphicsContext(Graphics2D graphics2D) {
        graphics2D.setStroke(this.myStroke);
        this.myFill.setGraphicsContext(graphics2D);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.myWidth);
        objectOutput.writeObject(this.myFill);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.myWidth = objectInput.readFloat();
        this.myFill = (Fill)objectInput.readObject();
        this.computeStroke();
    }

    private void computeStroke() {
        this.myStroke = new BasicStroke(this.myWidth, 1, 0, 10.0f);
    }
}

