/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.image.BaseColorImage;
import edu.rit.image.PJGImage;
import edu.rit.image.PJGImageFileFormatException;
import edu.rit.util.Range;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PJGColorImage
extends BaseColorImage {
    public PJGColorImage() {
        super(0);
    }

    public PJGColorImage(int n, int n2, int[][] nArray) {
        super(0);
        this.setMatrix(n, n2, nArray);
    }

    @Override
    public PJGImage.Writer prepareToWrite(OutputStream outputStream) throws IOException {
        return new ColorWriter(outputStream);
    }

    @Override
    public PJGImage.Reader prepareToRead(InputStream inputStream) throws IOException {
        return new ColorReader(inputStream);
    }

    private void writePixelData(DataOutputStream dataOutputStream, HashMap<Integer, Integer> hashMap, int n, int n2, int n3, int n4) throws IOException {
        dataOutputStream.writeByte(6);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeInt(n4);
        int n5 = n + n3;
        int n6 = n2 + n4;
        for (int i = n; i < n5; ++i) {
            int[] nArray = this.myMatrix[i];
            int n7 = 1;
            int n8 = nArray[n2];
            for (int j = n2 + 1; j < n6; ++j) {
                int n9 = nArray[j];
                if (n9 == n8) {
                    ++n7;
                    continue;
                }
                this.writeRun(dataOutputStream, hashMap, n7, n8);
                n7 = 1;
                n8 = n9;
            }
            this.writeRun(dataOutputStream, hashMap, n7, n8);
        }
    }

    private void writeRun(DataOutputStream dataOutputStream, HashMap<Integer, Integer> hashMap, int n, int n2) throws IOException {
        while (n > 0) {
            int n3;
            int n4 = Math.min(n - 1, Short.MAX_VALUE);
            if (n4 <= 127) {
                dataOutputStream.writeByte(n4);
            } else {
                dataOutputStream.writeByte(0x80 | n4 >> 8);
                dataOutputStream.writeByte(n4);
            }
            Integer n5 = hashMap.get(n2);
            if (n5 == null) {
                dataOutputStream.writeByte(224);
                dataOutputStream.writeByte(n2 >> 16);
                dataOutputStream.writeByte(n2 >> 8);
                dataOutputStream.writeByte(n2);
                n3 = hashMap.size();
                if (n3 < 0x200000) {
                    hashMap.put(n2, n3);
                }
            } else {
                n3 = n5;
                if (n3 <= 127) {
                    dataOutputStream.writeByte(n3);
                } else if (n3 <= 16383) {
                    dataOutputStream.writeByte(0x80 | n3 >> 8);
                    dataOutputStream.writeByte(n3);
                } else {
                    dataOutputStream.writeByte(0xC0 | n3 >> 16);
                    dataOutputStream.writeByte(n3 >> 8);
                    dataOutputStream.writeByte(n3);
                }
            }
            n -= 32768;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readPixelData(DataInputStream dataInputStream, ArrayList<Integer> arrayList, int n, int n2, int n3, int n4) throws IOException {
        if (this.myMatrix == null) {
            this.myMatrix = new int[this.myHeight][];
        }
        int n5 = n + n3;
        int n6 = n2 + n4;
        for (int i = n; i < n5; ++i) {
            int n7;
            int[] nArray = this.myMatrix[i];
            if (nArray == null) {
                nArray = new int[n6];
                this.myMatrix[i] = nArray;
            } else if (nArray.length < n6) {
                int[] nArray2 = new int[n6];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray = nArray2;
                this.myMatrix[i] = nArray2;
            }
            for (int j = n2; j < n6; j += n7) {
                n7 = dataInputStream.readUnsignedByte();
                if (n7 >= 128) {
                    n7 = (n7 & 0x7F) << 8 | dataInputStream.readUnsignedByte();
                }
                if (j + ++n7 > n6) {
                    throw new PJGImageFileFormatException("Invalid PJG pixel data run length (= " + n7 + ")");
                }
                int n8 = dataInputStream.readUnsignedByte();
                if (n8 > 224) {
                    throw new PJGImageFileFormatException("Invalid PJG pixel data value (= " + n8 + ")");
                }
                if (n8 == 224) {
                    n8 = dataInputStream.readUnsignedByte() << 16 | dataInputStream.readUnsignedByte() << 8 | dataInputStream.readUnsignedByte();
                    if (arrayList.size() < 0x200000) {
                        arrayList.add(n8);
                    }
                } else if (n8 >= 192) {
                    if ((n8 = (n8 & 0x1F) << 16 | dataInputStream.readUnsignedByte() << 8 | dataInputStream.readUnsignedByte()) >= arrayList.size()) throw new PJGImageFileFormatException("Invalid PJG pixel data index (= " + n8 + ")");
                    n8 = arrayList.get(n8);
                } else if (n8 >= 128) {
                    if ((n8 = (n8 & 0x3F) << 8 | dataInputStream.readUnsignedByte()) >= arrayList.size()) throw new PJGImageFileFormatException("Invalid PJG pixel data index (= " + n8 + ")");
                    n8 = arrayList.get(n8);
                } else {
                    if (n8 >= arrayList.size()) throw new PJGImageFileFormatException("Invalid PJG pixel data index (= " + n8 + ")");
                    n8 = arrayList.get(n8);
                }
                Arrays.fill(nArray, j, j + n7, n8);
            }
        }
    }

    private class ColorReader
    extends PJGImage.Reader {
        ArrayList<Integer> myReverseDictionary;
        int myRow;
        int myCol;
        int myRowLen;
        int myColLen;

        ColorReader(InputStream inputStream) throws IOException {
            super(PJGColorImage.this, inputStream);
            this.myReverseDictionary = new ArrayList();
            this.getPixelDataSegmentParameters();
        }

        public void read() throws IOException {
            while (this.myNextSegmentType != -1) {
                this.readSegment();
            }
        }

        public Range getRowRange() {
            return this.myNextSegmentType == -1 ? null : new Range(this.myRow, this.myRow + this.myRowLen - 1);
        }

        public Range getColRange() {
            return this.myNextSegmentType == -1 ? null : new Range(this.myCol, this.myCol + this.myColLen - 1);
        }

        public void readSegment() throws IOException {
            if (this.myNextSegmentType == -1) {
                return;
            }
            PJGColorImage.this.readPixelData(this.myDis, this.myReverseDictionary, this.myRow, this.myCol, this.myRowLen, this.myColLen);
            this.myNextSegmentType = this.myDis.read();
            this.getPixelDataSegmentParameters();
        }

        private void getPixelDataSegmentParameters() throws IOException {
            if (this.myNextSegmentType == -1) {
                return;
            }
            if (this.myNextSegmentType != 6) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment type (= " + this.myNextSegmentType + ")");
            }
            this.myRow = this.myDis.readInt();
            if (0 > this.myRow || this.myRow >= PJGColorImage.this.myHeight) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment row index (= " + this.myRow + ")");
            }
            this.myCol = this.myDis.readInt();
            if (0 > this.myCol || this.myCol >= PJGColorImage.this.myWidth) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment column index (= " + this.myCol + ")");
            }
            this.myRowLen = this.myDis.readInt();
            if (1 > this.myRowLen || this.myRow + this.myRowLen > PJGColorImage.this.myHeight) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment row count (= " + this.myRowLen + ")");
            }
            this.myColLen = this.myDis.readInt();
            if (1 > this.myColLen || this.myCol + this.myColLen > PJGColorImage.this.myWidth) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment column count (= " + this.myColLen + ")");
            }
        }
    }

    private class ColorWriter
    extends PJGImage.Writer {
        private HashMap<Integer, Integer> myDictionary;

        private ColorWriter(OutputStream outputStream) throws IOException {
            super(PJGColorImage.this, outputStream);
            this.myDictionary = new HashMap();
        }

        public void write() throws IOException {
            PJGColorImage.this.writePixelData(this.myDos, this.myDictionary, 0, 0, PJGColorImage.this.myHeight, PJGColorImage.this.myWidth);
        }

        public void writeRowSlice(Range range) throws IOException {
            int n = range.lb();
            int n2 = range.ub();
            int n3 = range.length();
            int n4 = range.stride();
            if (0 > n || n2 >= PJGColorImage.this.myHeight) {
                throw new IndexOutOfBoundsException("PJGImage.Writer.writeRowSlice(): Image row range = 0.." + (PJGColorImage.this.myHeight - 1) + ", theRowRange = " + range);
            }
            if (n4 > 1) {
                throw new IllegalArgumentException("PJGImage.Writer.writeRowSlice(): theRowRange stride = " + n4 + " illegal");
            }
            PJGColorImage.this.writePixelData(this.myDos, this.myDictionary, n, 0, n3, PJGColorImage.this.myWidth);
        }

        public void writeColSlice(Range range) throws IOException {
            int n = range.lb();
            int n2 = range.ub();
            int n3 = range.length();
            int n4 = range.stride();
            if (0 > n || n2 >= PJGColorImage.this.myWidth) {
                throw new IndexOutOfBoundsException("PJGImage.Writer.writeColSlice(): Image column range = 0.." + (PJGColorImage.this.myWidth - 1) + ", theColRange = " + range);
            }
            if (n4 > 1) {
                throw new IllegalArgumentException("PJGImage.Writer.writeColSlice(): theColRange stride = " + n4 + " illegal");
            }
            PJGColorImage.this.writePixelData(this.myDos, this.myDictionary, 0, n, PJGColorImage.this.myHeight, n3);
        }

        public void writePatch(Range range, Range range2) throws IOException {
            int n = range.lb();
            int n2 = range.ub();
            int n3 = range.length();
            int n4 = range.stride();
            if (0 > n || n2 >= PJGColorImage.this.myHeight) {
                throw new IndexOutOfBoundsException("PJGImage.Writer.writePatch(): Image row range = 0.." + (PJGColorImage.this.myHeight - 1) + ", theRowRange = " + range);
            }
            if (n4 > 1) {
                throw new IllegalArgumentException("PJGImage.Writer.writePatch(): theRowRange stride = " + n4 + " illegal");
            }
            int n5 = range2.lb();
            int n6 = range2.ub();
            int n7 = range2.length();
            int n8 = range2.stride();
            if (0 > n5 || n6 >= PJGColorImage.this.myWidth) {
                throw new IndexOutOfBoundsException("PJGImage.Writer.writePatch(): Image column range = 0.." + (PJGColorImage.this.myWidth - 1) + ", theColRange = " + range2);
            }
            if (n8 > 1) {
                throw new IllegalArgumentException("PJGImage.Writer.writePatch(): theColRange stride = " + n8 + " illegal");
            }
            PJGColorImage.this.writePixelData(this.myDos, this.myDictionary, n, n5, n3, n7);
        }
    }
}

