/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.CharacterBuf;
import edu.rit.mp.buf.CharacterArrayReductionBuf;
import edu.rit.pj.reduction.CharacterOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class CharacterArrayBuf
extends CharacterBuf {
    char[] myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public CharacterArrayBuf(char[] cArray, Range range) {
        super(range.length());
        this.myArray = cArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public char get(int n) {
        return this.myArray[this.myArrayOffset + n * this.myStride];
    }

    public void put(int n, char c) {
        this.myArray[this.myArrayOffset + n * this.myStride] = c;
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof CharacterArrayBuf) {
                CharacterArrayBuf characterArrayBuf = (CharacterArrayBuf)buf;
                Arrays.copy(characterArrayBuf.myArray, characterArrayBuf.myRange, this.myArray, this.myRange);
            } else {
                CharacterBuf.defaultCopy((CharacterBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        return new CharacterArrayReductionBuf(this.myArray, this.myRange, (CharacterOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = n;
        int n3 = this.myArrayOffset + n * this.myStride;
        while (n2 < this.myLength && byteBuffer.remaining() >= 2) {
            byteBuffer.putChar(this.myArray[n3]);
            ++n2;
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 2) {
            this.myArray[n4] = byteBuffer.getChar();
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

