/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.mri.PixelChunk;
import edu.rit.mri.SignalDataSetReader;
import java.io.File;
import java.io.IOException;

public class PixelSchedule {
    private int chunkSize;
    private String[] signalFileName;
    private int fileIndex;
    private int pixelIndex;
    private int pixelsRemaining;

    public PixelSchedule(int n, String[] stringArray) {
        this.chunkSize = n;
        this.signalFileName = stringArray;
        this.fileIndex = -1;
        this.pixelIndex = 0;
        this.pixelsRemaining = 0;
    }

    public PixelChunk next() throws IOException {
        if (this.pixelsRemaining == 0) {
            this.fileIndex = Math.min(this.fileIndex + 1, this.signalFileName.length);
            if (this.fileIndex == this.signalFileName.length) {
                return null;
            }
            SignalDataSetReader signalDataSetReader = new SignalDataSetReader(new File(this.signalFileName[this.fileIndex]));
            this.pixelIndex = 0;
            this.pixelsRemaining = signalDataSetReader.getPixelCount();
            signalDataSetReader.close();
        }
        int n = Math.min(this.chunkSize, this.pixelsRemaining);
        PixelChunk pixelChunk = new PixelChunk(this.fileIndex, this.pixelIndex, n);
        this.pixelIndex += n;
        this.pixelsRemaining -= n;
        return pixelChunk;
    }
}

