/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot;

import edu.rit.numeric.plot.AxisDialog;
import edu.rit.numeric.plot.Plot;
import edu.rit.numeric.plot.PlotAreaDialog;
import edu.rit.numeric.plot.PlotMarginsDialog;
import edu.rit.numeric.plot.TitleDialog;
import edu.rit.swing.Displayable;
import edu.rit.swing.DisplayableFrame;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

class PlotFrame
extends DisplayableFrame {
    private Plot myPlot;
    private TitleDialog myPlotTitleDialog;
    private PlotMarginsDialog myPlotMarginsDialog;
    private PlotAreaDialog myPlotAreaDialog;
    private AxisDialog myXAxisDialog;
    private TitleDialog myXAxisTitleDialog;
    private AxisDialog myYAxisDialog;
    private TitleDialog myYAxisTitleDialog;

    public PlotFrame(Plot plot) {
        super(plot);
        this.initialize(plot);
    }

    public PlotFrame(String string, Plot plot) {
        super(string, plot);
        this.initialize(plot);
    }

    public PlotFrame(Plot plot, int n) {
        super(plot, n);
        this.initialize(plot);
    }

    public PlotFrame(String string, Plot plot, int n) {
        super(string, plot, n);
        this.initialize(plot);
    }

    private void initialize(Plot plot) {
        if (plot == null) {
            throw new NullPointerException("PlotFrame(): thePlot is null");
        }
        this.myPlot = plot;
        JMenuBar jMenuBar = this.getJMenuBar();
        JMenu jMenu = jMenuBar.getMenu(0);
        JMenuItem jMenuItem = new JMenuItem("Save as Drawing...", 68);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doSaveAsDrawing();
            }
        });
        jMenu.insert(jMenuItem, 2);
        JMenu jMenu2 = jMenuBar.getMenu(1);
        JMenuItem jMenuItem2 = new JMenuItem("Window Title...", 84);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doWindowTitle();
            }
        });
        jMenu2.add(jMenuItem2);
        JMenu jMenu3 = new JMenu("Format");
        jMenu3.setMnemonic(79);
        JMenuItem jMenuItem3 = new JMenuItem("Plot Title...", 80);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doPlotTitle();
            }
        });
        jMenu3.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Margins...", 77);
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doMargins();
            }
        });
        jMenu3.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Plot Area...", 65);
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doPlotArea();
            }
        });
        jMenu3.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("X Axis...", 88);
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doXAxis();
            }
        });
        jMenu3.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem("X Axis Title...", 73);
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doXAxisTitle();
            }
        });
        jMenu3.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Y Axis...", 89);
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doYAxis();
            }
        });
        jMenu3.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem("Y Axis Title...", 84);
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doYAxisTitle();
            }
        });
        jMenu3.add(jMenuItem9);
        jMenuBar.add(jMenu3);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PlotFrame.this.doClose();
            }
        });
    }

    public void display(Displayable displayable) {
        this.myPlot = (Plot)displayable;
        super.display(displayable);
    }

    private void doSaveAsDrawing() {
        this.saveFile(".dwg", "Serialized drawing object files", new DisplayableFrame.FileSaver(){

            public void saveFile(File file) throws IOException {
                Plot.write(PlotFrame.this.myPlot, file);
            }
        });
    }

    private void doWindowTitle() {
        String string = JOptionPane.showInputDialog(this, "Window title:", this.myPlot.getTitle());
        if (string != null) {
            this.myPlot.frameTitle(string);
            this.setTitle(string);
        }
    }

    private void doPlotTitle() {
        if (this.myPlotTitleDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myPlotTitleDialog = new TitleDialog((Frame)this, "Plot");
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.myPlot.formatPlotTitle(this.myPlotTitleDialog)) {
            this.setTitle(this.myPlot.getTitle());
            this.repaint();
        }
    }

    private void doMargins() {
        if (this.myPlotMarginsDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myPlotMarginsDialog = new PlotMarginsDialog(this);
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.myPlot.formatPlotMargins(this.myPlotMarginsDialog)) {
            this.repaint();
        }
    }

    private void doPlotArea() {
        if (this.myPlotAreaDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myPlotAreaDialog = new PlotAreaDialog(this);
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.myPlot.formatPlotArea(this.myPlotAreaDialog)) {
            this.repaint();
        }
    }

    private void doXAxis() {
        if (this.myXAxisDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myXAxisDialog = new AxisDialog((Frame)this, "X");
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.myPlot.formatXAxis(this.myXAxisDialog)) {
            this.repaint();
        }
    }

    private void doXAxisTitle() {
        if (this.myXAxisTitleDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myXAxisTitleDialog = new TitleDialog((Frame)this, "X Axis");
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.myPlot.formatXAxisTitle(this.myXAxisTitleDialog)) {
            this.repaint();
        }
    }

    private void doYAxis() {
        if (this.myYAxisDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myYAxisDialog = new AxisDialog((Frame)this, "Y");
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.myPlot.formatYAxis(this.myYAxisDialog)) {
            this.repaint();
        }
    }

    private void doYAxisTitle() {
        if (this.myYAxisTitleDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myYAxisTitleDialog = new TitleDialog((Frame)this, "Y Axis");
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.myPlot.formatYAxisTitle(this.myYAxisTitleDialog)) {
            this.repaint();
        }
    }

    private void doClose() {
        if (this.myPlotTitleDialog != null) {
            this.myPlotTitleDialog.dispose();
            this.myPlotTitleDialog = null;
        }
        if (this.myPlotMarginsDialog != null) {
            this.myPlotMarginsDialog.dispose();
            this.myPlotMarginsDialog = null;
        }
        if (this.myPlotAreaDialog != null) {
            this.myPlotAreaDialog.dispose();
            this.myPlotAreaDialog = null;
        }
        if (this.myXAxisTitleDialog != null) {
            this.myXAxisTitleDialog.dispose();
            this.myXAxisTitleDialog = null;
        }
        if (this.myYAxisTitleDialog != null) {
            this.myYAxisTitleDialog.dispose();
            this.myYAxisTitleDialog = null;
        }
    }
}

