/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.mp.Buf;
import edu.rit.mp.IntegerBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.PJProperties;
import edu.rit.pj.WorkerTeam;
import edu.rit.util.Range;
import java.io.IOException;

public class HybridTeam
extends WorkerTeam {
    int[] lowestIndex;

    public HybridTeam() throws IOException {
        this(HybridTeam.getDefaultThreadCount(), Comm.world());
    }

    public HybridTeam(int n) throws IOException {
        this(n, Comm.world());
    }

    public HybridTeam(Comm comm) throws IOException {
        this(HybridTeam.getDefaultThreadCount(), comm);
    }

    public HybridTeam(int n, Comm comm) throws IOException {
        super(false);
        if (n <= 0) {
            throw new IllegalArgumentException("HybridTeam(): K = " + n + " illegal");
        }
        if (comm == null) {
            throw new NullPointerException("HybridTeam(): comm is null");
        }
        int n2 = comm.size();
        int n3 = comm.rank();
        this.lowestIndex = new int[n2 + 1];
        this.lowestIndex[n3] = n;
        Buf[] bufArray = IntegerBuf.sliceBuffers(this.lowestIndex, new Range(0, n2 - 1).subranges(n2));
        IntegerBuf integerBuf = bufArray[n3];
        comm.allGather(Integer.MIN_VALUE, integerBuf, bufArray);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = this.lowestIndex[i];
            this.lowestIndex[i] = n4;
            n4 += n5;
        }
        this.lowestIndex[n2] = n4;
        this.initialize(n, comm, n2, n3, n4, this.lowestIndex[n3]);
    }

    public static int getDefaultThreadCount() {
        int n = PJProperties.getPjNt();
        if (n == 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        return n;
    }

    public int workerRank(int n) {
        if (0 > n || n >= this.count) {
            throw new IllegalArgumentException("HybridTeam.workerRank(): w (= " + n + ") illegal");
        }
        int n2 = 0;
        int n3 = this.size;
        while (n3 - n2 > 1) {
            int n4 = (n2 + n3) / 2;
            if (n >= this.lowestIndex[n4]) {
                n2 = n4;
                continue;
            }
            n3 = n4;
        }
        return n2;
    }
}

