/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.ChannelGroupClosedException;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.Status;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.PJProperties;
import edu.rit.pj.cluster.FrontendFileReader;
import edu.rit.pj.cluster.FrontendFileWriter;
import edu.rit.pj.cluster.JobBackendProxy;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendMessage;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.JobSchedulerException;
import edu.rit.pj.cluster.JobSchedulerProxy;
import edu.rit.pj.cluster.JobSchedulerRef;
import edu.rit.pj.cluster.ProcessInfo;
import edu.rit.pj.cluster.ResourceCache;
import edu.rit.util.ByteSequence;
import edu.rit.util.Timer;
import edu.rit.util.TimerTask;
import edu.rit.util.TimerThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class JobFrontend
implements Runnable,
JobFrontendRef {
    private String username;
    private int jobnum;
    private int Nn;
    private int Np;
    private int Nt;
    private boolean hasFrontendComm;
    private String myMainClassName;
    private String[] myArgs;
    private int myNextRank;
    private TimerThread myLeaseTimerThread;
    private Timer mySchedulerRenewTimer;
    private Timer mySchedulerExpireTimer;
    private Timer myJobTimer;
    private ProcessInfo[] myProcessInfo;
    private Map<JobBackendRef, ProcessInfo> myProcessMap = new HashMap<JobBackendRef, ProcessInfo>();
    private int myRunningCount;
    private int myFinishedCount;
    private ChannelGroup myMiddlewareChannelGroup;
    private InetSocketAddress[] myMiddlewareAddress;
    private JobSchedulerRef myJobScheduler;
    private InetSocketAddress[] myWorldAddress;
    private ChannelGroup myFrontendChannelGroup;
    private InetSocketAddress[] myFrontendAddress;
    private String userJvmFlags = PJProperties.getPjJvmFlags();
    private ResourceCache myResourceCache = new ResourceCache();
    private boolean continueRun = true;
    private State myState = State.RUNNING;
    private String myCancelMessage = "User canceled job";
    private FrontendFileWriter myFrontendFileWriter;
    private FrontendFileReader myFrontendFileReader;

    public JobFrontend(String string, int n, int n2, int n3, boolean bl, String string2, String[] stringArray) throws IOException {
        this.username = string;
        this.Nn = n;
        this.Np = n2;
        this.Nt = n3;
        this.hasFrontendComm = bl;
        this.myMainClassName = string2;
        this.myArgs = stringArray;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                JobFrontend.this.shutdown();
            }
        });
        this.myLeaseTimerThread = new TimerThread();
        this.myLeaseTimerThread.setDaemon(true);
        this.myLeaseTimerThread.start();
        this.mySchedulerRenewTimer = this.myLeaseTimerThread.createTimer(new TimerTask(){

            public void action(Timer timer) {
                try {
                    JobFrontend.this.schedulerRenewTimeout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.mySchedulerExpireTimer = this.myLeaseTimerThread.createTimer(new TimerTask(){

            public void action(Timer timer) {
                try {
                    JobFrontend.this.schedulerExpireTimeout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.myJobTimer = this.myLeaseTimerThread.createTimer(new TimerTask(){

            public void action(Timer timer) {
                try {
                    JobFrontend.this.jobTimeout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.myProcessInfo = new ProcessInfo[n2];
        int n4 = 0;
        while (n4 < n2) {
            ProcessInfo processInfo;
            final int n5 = n4++;
            this.myProcessInfo[n5] = processInfo = new ProcessInfo(ProcessInfo.State.NOT_STARTED, null, n5, null, null, null, null, this.myLeaseTimerThread.createTimer(new TimerTask(){

                public void action(Timer timer) {
                    try {
                        JobFrontend.this.backendRenewTimeout(n5);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }), this.myLeaseTimerThread.createTimer(new TimerTask(){

                public void action(Timer timer) {
                    try {
                        JobFrontend.this.backendExpireTimeout(n5);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }), 0);
        }
        this.myMiddlewareChannelGroup = new ChannelGroup();
        this.myMiddlewareAddress = new InetSocketAddress[n2 + 1];
        this.myWorldAddress = new InetSocketAddress[n2];
        if (bl) {
            this.myFrontendChannelGroup = new ChannelGroup();
            this.myFrontendAddress = new InetSocketAddress[n2 + 1];
        }
        this.myFrontendFileWriter = new FrontendFileWriter(this);
        this.myFrontendFileReader = new FrontendFileReader(this);
        InetSocketAddress inetSocketAddress = null;
        Channel channel = null;
        try {
            inetSocketAddress = new InetSocketAddress(PJProperties.getPjHost(), PJProperties.getPjPort());
            channel = this.myMiddlewareChannelGroup.connect(inetSocketAddress);
        }
        catch (IOException iOException) {
            throw new JobSchedulerException("JobFrontend(): Cannot contact Job Scheduler Daemon at " + inetSocketAddress, iOException);
        }
        this.myJobScheduler = new JobSchedulerProxy(this.myMiddlewareChannelGroup, channel);
        this.mySchedulerRenewTimer.start(60000L, 60000L);
        this.mySchedulerExpireTimer.start(150000L);
        this.myJobScheduler.requestJob(this, string, n, n2, n3);
    }

    public void run() {
        ObjectItemBuf<JobFrontendMessage> objectItemBuf = ObjectBuf.buffer((JobFrontendMessage)null);
        Status status = null;
        JobFrontendMessage jobFrontendMessage = null;
        JobBackendRef jobBackendRef = null;
        try {
            while (this.continueRun) {
                status = this.myMiddlewareChannelGroup.receive(null, null, objectItemBuf);
                jobFrontendMessage = (JobFrontendMessage)objectItemBuf.item;
                if (status.tag == 4) {
                    jobFrontendMessage.invoke((JobFrontendRef)this, this.myJobScheduler);
                } else if (status.tag == 1) {
                    jobBackendRef = (JobBackendRef)status.channel.info();
                    if (jobBackendRef == null) {
                        jobBackendRef = new JobBackendProxy(this.myMiddlewareChannelGroup, status.channel);
                        status.channel.info(jobBackendRef);
                    }
                    jobFrontendMessage.invoke((JobFrontendRef)this, jobBackendRef);
                }
                objectItemBuf.item = null;
                status = null;
                jobFrontendMessage = null;
                jobBackendRef = null;
            }
        }
        catch (ChannelGroupClosedException channelGroupClosedException) {
        }
        catch (Throwable throwable) {
            this.terminateCancelJob(throwable);
        }
        switch (this.myState) {
            case TERMINATE_CANCEL_JOB: {
                System.exit(1);
                break;
            }
        }
    }

    public void assignBackend(JobSchedulerRef jobSchedulerRef, String string, String string2, String string3, String string4, String[] stringArray, String string5, int n) throws IOException {
        int n2 = this.myNextRank++;
        ProcessInfo processInfo = this.myProcessInfo[n2];
        processInfo.name = string;
        processInfo.Nt = n;
        System.err.print(", ");
        System.err.print(string);
        System.err.flush();
        if (this.myNextRank == this.Np) {
            System.err.println();
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string5);
            stringBuilder.append(" \"");
            String string6 = System.getProperty("user.dir");
            if (string6 != null) {
                stringBuilder.append("cd '");
                stringBuilder.append(string6);
                stringBuilder.append("'; ");
            }
            stringBuilder.append("nohup ");
            stringBuilder.append(string3);
            stringBuilder.append(" -classpath '");
            stringBuilder.append(string4);
            stringBuilder.append("'");
            for (String string7 : stringArray) {
                stringBuilder.append(" ");
                stringBuilder.append(string7);
            }
            stringBuilder.append(" ");
            stringBuilder.append(this.userJvmFlags);
            stringBuilder.append(" edu.rit.pj.cluster.JobBackend '");
            stringBuilder.append(this.username);
            stringBuilder.append("' ");
            stringBuilder.append(this.jobnum);
            stringBuilder.append(" ");
            stringBuilder.append(this.Np);
            stringBuilder.append(" ");
            stringBuilder.append(n2);
            stringBuilder.append(" ");
            stringBuilder.append(this.hasFrontendComm);
            stringBuilder.append(" '");
            stringBuilder.append(this.myMiddlewareChannelGroup.listenAddress().getHostName());
            stringBuilder.append("' ");
            stringBuilder.append(this.myMiddlewareChannelGroup.listenAddress().getPort());
            stringBuilder.append(" '");
            stringBuilder.append(string2);
            stringBuilder.append("' >/dev/null 2>/dev/null &\"");
            Process process = Runtime.getRuntime().exec(new String[]{"ssh", string2, stringBuilder.toString()});
            processInfo.renewTimer.start(60000L, 60000L);
            processInfo.expireTimer.start(150000L);
        }
        catch (IOException iOException) {
            if (this.myNextRank != this.Np) {
                System.err.println();
            }
            this.terminateCancelJob(this.backendFailed(processInfo));
        }
    }

    public synchronized void assignJobNumber(JobSchedulerRef jobSchedulerRef, int n, String string) throws IOException {
        this.jobnum = n;
        this.myMiddlewareChannelGroup.listen(new InetSocketAddress(string, 0));
        this.myMiddlewareChannelGroup.startListening();
        this.myMiddlewareAddress[this.Np] = this.myMiddlewareChannelGroup.listenAddress();
        if (this.hasFrontendComm) {
            this.myFrontendChannelGroup.listen(new InetSocketAddress(string, 0));
            this.myFrontendChannelGroup.startListening();
            this.myFrontendAddress[this.Np] = this.myFrontendChannelGroup.listenAddress();
        }
        System.err.print("Job " + n);
        System.err.flush();
    }

    public synchronized void cancelJob(JobSchedulerRef jobSchedulerRef, String string) throws IOException {
        this.terminateCancelJob(string);
    }

    public synchronized void renewLease(JobSchedulerRef jobSchedulerRef) throws IOException {
        this.mySchedulerExpireTimer.start(150000L);
    }

    public synchronized void backendFinished(JobBackendRef jobBackendRef) throws IOException {
        ProcessInfo processInfo = this.myProcessMap.get(jobBackendRef);
        if (processInfo == null) {
            return;
        }
        if (processInfo.state != ProcessInfo.State.RUNNING) {
            this.terminateCancelJob("Unexpected \"backend finished\" message, rank=" + processInfo.rank);
        }
        processInfo.state = ProcessInfo.State.FINISHED;
        ++this.myFinishedCount;
        if (this.myFinishedCount == this.Np) {
            this.continueRun = false;
            this.myCancelMessage = null;
        }
    }

    public synchronized void backendReady(JobBackendRef jobBackendRef, int n, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, InetSocketAddress inetSocketAddress3) throws IOException {
        if (0 > n || n >= this.Np) {
            this.terminateCancelJob("Illegal \"backend ready\" message, rank=" + n);
        }
        ProcessInfo processInfo = this.myProcessInfo[n];
        if (processInfo.state != ProcessInfo.State.NOT_STARTED) {
            this.terminateCancelJob("Unexpected \"backend ready\" message, rank=" + n);
        }
        processInfo.state = ProcessInfo.State.RUNNING;
        processInfo.backend = jobBackendRef;
        processInfo.middlewareAddress = inetSocketAddress;
        processInfo.worldAddress = inetSocketAddress2;
        processInfo.frontendAddress = inetSocketAddress3;
        this.myProcessMap.put(jobBackendRef, processInfo);
        this.myMiddlewareAddress[n] = inetSocketAddress;
        this.myWorldAddress[n] = inetSocketAddress2;
        if (this.hasFrontendComm) {
            this.myFrontendAddress[n] = inetSocketAddress3;
        }
        ++this.myRunningCount;
        if (this.myRunningCount == this.Np) {
            int n2 = PJProperties.getPjJobTime();
            if (n2 > 0) {
                this.myJobTimer.start((long)n2 * 1000L);
            }
            Properties properties = System.getProperties();
            for (ProcessInfo processInfo2 : this.myProcessMap.values()) {
                properties.setProperty("pj.nt", "" + processInfo2.Nt);
                processInfo2.backend.commenceJob(this, this.myMiddlewareAddress, this.myWorldAddress, this.myFrontendAddress, properties, this.myMainClassName, this.myArgs);
            }
        }
    }

    public synchronized void cancelJob(JobBackendRef jobBackendRef, String string) throws IOException {
        this.terminateCancelJob(string);
    }

    public synchronized void renewLease(JobBackendRef jobBackendRef) throws IOException {
        ProcessInfo processInfo = this.myProcessMap.get(jobBackendRef);
        if (processInfo != null) {
            processInfo.expireTimer.start(150000L);
        }
    }

    public synchronized void requestResource(JobBackendRef jobBackendRef, String string) throws IOException {
        byte[] byArray = null;
        if (this.myResourceCache.contains(string)) {
            byArray = this.myResourceCache.getNoWait(string);
        } else {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
            if (inputStream != null) {
                byArray = new ByteSequence(inputStream).toByteArray();
            }
            this.myResourceCache.put(string, byArray);
        }
        jobBackendRef.reportResource((JobFrontendRef)this, string, byArray);
    }

    public synchronized void outputFileOpen(JobBackendRef jobBackendRef, int n, File file, boolean bl) throws IOException {
        this.myFrontendFileWriter.outputFileOpen(jobBackendRef, n, file, bl);
    }

    public synchronized void outputFileWrite(JobBackendRef jobBackendRef, int n, byte[] byArray, int n2, int n3) throws IOException {
        this.myFrontendFileWriter.outputFileWrite(jobBackendRef, n, n3);
    }

    public synchronized void outputFileFlush(JobBackendRef jobBackendRef, int n) throws IOException {
        this.myFrontendFileWriter.outputFileFlush(jobBackendRef, n);
    }

    public synchronized void outputFileClose(JobBackendRef jobBackendRef, int n) throws IOException {
        this.myFrontendFileWriter.outputFileClose(jobBackendRef, n);
    }

    public synchronized void inputFileOpen(JobBackendRef jobBackendRef, int n, File file) throws IOException {
        this.myFrontendFileReader.inputFileOpen(jobBackendRef, n, file);
    }

    public synchronized void inputFileRead(JobBackendRef jobBackendRef, int n, int n2) throws IOException {
        this.myFrontendFileReader.inputFileRead(jobBackendRef, n, n2);
    }

    public synchronized void inputFileSkip(JobBackendRef jobBackendRef, int n, long l) throws IOException {
        this.myFrontendFileReader.inputFileSkip(jobBackendRef, n, l);
    }

    public synchronized void inputFileClose(JobBackendRef jobBackendRef, int n) throws IOException {
        this.myFrontendFileReader.inputFileClose(jobBackendRef, n);
    }

    public synchronized void reportComment(JobBackendRef jobBackendRef, int n, String string) throws IOException {
        this.myJobScheduler.reportComment(this, n, string);
    }

    public void close() {
    }

    private synchronized void schedulerRenewTimeout() throws IOException {
        if (this.mySchedulerRenewTimer.isTriggered()) {
            this.myJobScheduler.renewLease(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulerExpireTimeout() throws IOException {
        boolean bl = false;
        JobFrontend jobFrontend = this;
        synchronized (jobFrontend) {
            if (this.mySchedulerExpireTimer.isTriggered()) {
                this.continueRun = false;
                if (this.myState == State.RUNNING) {
                    this.myState = State.TERMINATE_CANCEL_JOB;
                    this.myCancelMessage = "Job Scheduler failed";
                    System.err.println(this.myCancelMessage);
                    bl = true;
                }
            }
        }
        if (bl) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobTimeout() throws IOException {
        boolean bl = false;
        JobFrontend jobFrontend = this;
        synchronized (jobFrontend) {
            if (this.myJobTimer.isTriggered()) {
                this.continueRun = false;
                if (this.myState == State.RUNNING) {
                    this.myState = State.TERMINATE_CANCEL_JOB;
                    this.myCancelMessage = "Job exceeded maximum running time";
                    System.err.println(this.myCancelMessage);
                    bl = true;
                }
            }
        }
        if (bl) {
            System.exit(1);
        }
    }

    private synchronized void backendRenewTimeout(int n) throws IOException {
        ProcessInfo processInfo = this.myProcessInfo[n];
        if (processInfo.renewTimer.isTriggered()) {
            processInfo.backend.renewLease(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backendExpireTimeout(int n) throws IOException {
        boolean bl = false;
        JobFrontend jobFrontend = this;
        synchronized (jobFrontend) {
            ProcessInfo processInfo = this.myProcessInfo[n];
            if (processInfo.expireTimer.isTriggered()) {
                String string = this.backendFailed(processInfo);
                this.continueRun = false;
                if (this.myState == State.RUNNING) {
                    this.myState = State.TERMINATE_CANCEL_JOB;
                    this.myCancelMessage = string;
                    System.err.println(this.myCancelMessage);
                    bl = true;
                }
            }
        }
        if (bl) {
            System.exit(1);
        }
    }

    private String backendFailed(ProcessInfo processInfo) {
        processInfo.state = ProcessInfo.State.FAILED;
        try {
            this.myJobScheduler.backendFailed(this, processInfo.name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "Job backend process failed, node " + processInfo.name + ", rank " + processInfo.rank;
    }

    private void terminateCancelJob(String string) {
        this.continueRun = false;
        if (this.myState == State.RUNNING) {
            this.myState = State.TERMINATE_CANCEL_JOB;
            this.myCancelMessage = string;
            System.err.println(this.myCancelMessage);
        }
    }

    private void terminateCancelJob(Throwable throwable) {
        this.continueRun = false;
        if (this.myState == State.RUNNING) {
            this.myCancelMessage = throwable.getClass().getName();
            String string = throwable.getMessage();
            if (string != null) {
                this.myCancelMessage = this.myCancelMessage + ": " + string;
            }
            System.err.println(this.myCancelMessage);
            throwable.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateCancelJobOther(Throwable throwable) {
        boolean bl = false;
        JobFrontend jobFrontend = this;
        synchronized (jobFrontend) {
            this.continueRun = false;
            if (this.myState == State.RUNNING) {
                this.myCancelMessage = throwable.getClass().getName();
                String string = throwable.getMessage();
                if (string != null) {
                    this.myCancelMessage = this.myCancelMessage + ": " + string;
                }
                System.err.println(this.myCancelMessage);
                throwable.printStackTrace(System.err);
                bl = true;
            }
        }
        if (bl) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        JobFrontend jobFrontend = this;
        synchronized (jobFrontend) {
            this.mySchedulerRenewTimer.stop();
            this.mySchedulerExpireTimer.stop();
            for (ProcessInfo processInfo : this.myProcessInfo) {
                processInfo.renewTimer.stop();
                processInfo.expireTimer.stop();
            }
            if (this.myState == State.RUNNING && this.myCancelMessage != null) {
                this.myState = State.TERMINATE_CANCEL_JOB;
            }
            switch (this.myState) {
                case RUNNING: {
                    for (ProcessInfo processInfo : this.myProcessInfo) {
                        if (processInfo.backend == null) continue;
                        try {
                            processInfo.backend.jobFinished(this);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (this.myJobScheduler == null) break;
                    try {
                        this.myJobScheduler.jobFinished(this);
                    }
                    catch (IOException iOException) {}
                    break;
                }
                case TERMINATE_CANCEL_JOB: {
                    for (ProcessInfo processInfo : this.myProcessInfo) {
                        if (processInfo.backend == null || processInfo.state == ProcessInfo.State.FAILED) continue;
                        try {
                            processInfo.backend.cancelJob(this, this.myCancelMessage);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (this.myJobScheduler == null) break;
                    try {
                        this.myJobScheduler.cancelJob(this, this.myCancelMessage);
                    }
                    catch (IOException iOException) {}
                    break;
                }
            }
            this.myState = State.TERMINATING;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        RUNNING,
        TERMINATE_CANCEL_JOB,
        TERMINATING;

    }
}

