/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.job;

import edu.rit.io.Stdio;
import edu.rit.pj.job.Stderr;
import edu.rit.pj.job.Stdin;
import edu.rit.pj.job.Stdout;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class Job
implements Runnable,
Externalizable {
    private int myJobNumber;
    private String myDescription;
    private String myMainClassName;
    private ArrayList<String> myArguments = new ArrayList();
    private Stdin myStdinRedirection = Stdin.NONE;
    private Stdout myStdoutRedirection = Stdout.NONE;
    private Stderr myStderrRedirection = Stderr.NONE;
    private File myStdinFile = null;
    private File myStdoutFile = null;
    private File myStderrFile = null;

    public Job() {
    }

    public Job(int n, String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("Job(): Main class name is null");
        }
        this.myJobNumber = n;
        this.myDescription = string;
        this.myMainClassName = string2;
    }

    public int getJobNumber() {
        return this.myJobNumber;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void addArgument(String string) {
        if (string == null) {
            throw new NullPointerException("Job.addArgument(): Argument string is null");
        }
        this.myArguments.add(string);
    }

    public void stdinFromFile(File file) {
        if (file == null) {
            throw new NullPointerException("Job.stdinFromFile(): File is null");
        }
        this.myStdinRedirection = Stdin.FILE;
        this.myStdinFile = file;
    }

    public void stdoutToFile(File file) {
        if (file == null) {
            throw new NullPointerException("Job.stdoutToFile(): File is null");
        }
        this.myStdoutRedirection = Stdout.FILE;
        this.myStdoutFile = file;
    }

    public void stdoutAppendToFile(File file) {
        if (file == null) {
            throw new NullPointerException("Job.stdoutAppendToFile(): File is null");
        }
        this.myStdoutRedirection = Stdout.FILE_APPEND;
        this.myStdoutFile = file;
    }

    public void stderrToFile(File file) {
        if (file == null) {
            throw new NullPointerException("Job.stderrToFile(): File is null");
        }
        this.myStderrRedirection = Stderr.FILE;
        this.myStderrFile = file;
    }

    public void stderrAppendToFile(File file) {
        if (file == null) {
            throw new NullPointerException("Job.stderrAppendToFile(): File is null");
        }
        this.myStderrRedirection = Stderr.FILE_APPEND;
        this.myStderrFile = file;
    }

    public void stderrToStdout() {
        this.myStderrRedirection = Stderr.STDOUT;
        this.myStderrFile = null;
    }

    public void run() {
        try {
            switch (this.myStdinRedirection) {
                case FILE: {
                    Stdio.in(new FileInputStream(this.myStdinFile));
                }
            }
            switch (this.myStdoutRedirection) {
                case FILE: {
                    Stdio.out(new PrintStream(new FileOutputStream(this.myStdoutFile, false), true));
                    break;
                }
                case FILE_APPEND: {
                    Stdio.out(new PrintStream(new FileOutputStream(this.myStdoutFile, true), true));
                }
            }
            switch (this.myStderrRedirection) {
                case FILE: {
                    Stdio.err(new PrintStream(new FileOutputStream(this.myStderrFile, false), true));
                    break;
                }
                case FILE_APPEND: {
                    Stdio.err(new PrintStream(new FileOutputStream(this.myStderrFile, true), true));
                    break;
                }
                case STDOUT: {
                    Stdio.err(Stdio.out());
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        try {
            Class<?> clazz = Class.forName(this.myMainClassName, true, Thread.currentThread().getContextClassLoader());
            Method method = clazz.getMethod("main", String[].class);
            int n = method.getModifiers();
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new NoSuchMethodException("Job.run(): Class " + clazz.getName() + " main() method is not static");
            }
            if (method.getReturnType() != Void.TYPE) {
                throw new NoSuchMethodException("Job.run(): Class " + clazz.getName() + " main() method does not return void");
            }
            String[] stringArray = this.myArguments.toArray(new String[this.myArguments.size()]);
            method.invoke(null, new Object[]{stringArray});
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(Stdio.err());
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.myJobNumber);
        objectOutput.writeUTF(this.myDescription);
        objectOutput.writeUTF(this.myMainClassName);
        objectOutput.writeInt(this.myArguments.size());
        for (String string : this.myArguments) {
            objectOutput.writeUTF(string);
        }
        objectOutput.writeObject((Object)this.myStdinRedirection);
        objectOutput.writeObject((Object)this.myStdoutRedirection);
        objectOutput.writeObject((Object)this.myStderrRedirection);
        objectOutput.writeObject(this.myStdinFile);
        objectOutput.writeObject(this.myStdoutFile);
        objectOutput.writeObject(this.myStderrFile);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.myJobNumber = objectInput.readInt();
        this.myDescription = objectInput.readUTF();
        this.myMainClassName = objectInput.readUTF();
        this.myArguments.clear();
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            this.myArguments.add(objectInput.readUTF());
        }
        this.myStdinRedirection = (Stdin)((Object)objectInput.readObject());
        this.myStdoutRedirection = (Stdout)((Object)objectInput.readObject());
        this.myStderrRedirection = (Stderr)((Object)objectInput.readObject());
        this.myStdinFile = (File)objectInput.readObject();
        this.myStdoutFile = (File)objectInput.readObject();
        this.myStderrFile = (File)objectInput.readObject();
    }
}

