/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.LongOp;
import java.util.concurrent.atomic.AtomicLongArray;

public class SharedLongMatrix {
    private AtomicLongArray[] myMatrix;

    public SharedLongMatrix(int n, int n2) {
        this.myMatrix = new AtomicLongArray[n];
        for (int i = 0; i < n; ++i) {
            this.myMatrix[i] = new AtomicLongArray(n2);
        }
    }

    public SharedLongMatrix(long[][] lArray) {
        this.myMatrix = new AtomicLongArray[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            this.myMatrix[i] = new AtomicLongArray(lArray[i]);
        }
    }

    public int rows() {
        return this.myMatrix.length;
    }

    public int cols() {
        return this.myMatrix[0].length();
    }

    public long get(int n, int n2) {
        return this.myMatrix[n].get(n2);
    }

    public void set(int n, int n2, long l) {
        this.myMatrix[n].set(n2, l);
    }

    public long getAndSet(int n, int n2, long l) {
        return this.myMatrix[n].getAndSet(n2, l);
    }

    public boolean compareAndSet(int n, int n2, long l, long l2) {
        return this.myMatrix[n].compareAndSet(n2, l, l2);
    }

    public boolean weakCompareAndSet(int n, int n2, long l, long l2) {
        return this.myMatrix[n].weakCompareAndSet(n2, l, l2);
    }

    public long getAndIncrement(int n, int n2) {
        return this.myMatrix[n].getAndIncrement(n2);
    }

    public long getAndDecrement(int n, int n2) {
        return this.myMatrix[n].getAndDecrement(n2);
    }

    public long getAndAdd(int n, int n2, long l) {
        return this.myMatrix[n].getAndAdd(n2, l);
    }

    public long incrementAndGet(int n, int n2) {
        return this.myMatrix[n].incrementAndGet(n2);
    }

    public long decrementAndGet(int n, int n2) {
        return this.myMatrix[n].decrementAndGet(n2);
    }

    public long addAndGet(int n, int n2, long l) {
        return this.myMatrix[n].addAndGet(n2, l);
    }

    public long reduce(int n, int n2, long l, LongOp longOp) {
        long l2;
        long l3;
        AtomicLongArray atomicLongArray = this.myMatrix[n];
        while (!atomicLongArray.compareAndSet(n2, l3 = atomicLongArray.get(n2), l2 = longOp.op(l3, l))) {
        }
        return l2;
    }

    public void reduce(long[][] lArray, LongOp longOp) {
        this.reduce(0, 0, lArray, 0, 0, this.rows(), this.cols(), longOp);
    }

    public void reduce(int n, int n2, long[][] lArray, int n3, int n4, int n5, int n6, LongOp longOp) {
        if (n5 < 0 || n6 < 0 || n < 0 || n + n5 > this.rows() || n2 < 0 || n2 + n6 > this.cols() || n3 < 0 || n3 + n5 > lArray.length || n4 < 0 || n4 + n6 > lArray[0].length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n5; ++i) {
            AtomicLongArray atomicLongArray = this.myMatrix[n + i];
            long[] lArray2 = lArray[n3 + i];
            for (int j = 0; j < n6; ++j) {
                long l;
                long l2;
                int n7 = n2 + j;
                long l3 = lArray2[n4 + j];
                while (!atomicLongArray.compareAndSet(n7, l2 = atomicLongArray.get(n7), l = longOp.op(l2, l3))) {
                }
            }
        }
    }
}

