/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.fractal;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.SharedIntegerArray;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class MSHistogramSmp2 {
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static File outfile;
    static int xoffset;
    static int yoffset;
    static SharedIntegerArray histogram;

    private MSHistogramSmp2() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        if (stringArray.length != 7) {
            MSHistogramSmp2.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        outfile = new File(stringArray[6]);
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        histogram = new SharedIntegerArray(maxiter + 1);
        long l2 = System.currentTimeMillis();
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                this.execute(0, height - 1, new IntegerForLoop(){
                    int[] thr_histogram = new int[maxiter + 1 + 32];
                    long p0;
                    long p1;
                    long p2;
                    long p3;
                    long p4;
                    long p5;
                    long p6;
                    long p7;
                    long p8;
                    long p9;
                    long pa;
                    long pb;
                    long pc;
                    long pd;
                    long pe;
                    long pf;

                    public void run(int n, int n2) {
                        for (int i = n; i <= n2; ++i) {
                            double d = ycenter + (double)(yoffset - i) / resolution;
                            for (int j = 0; j < width; ++j) {
                                int n3;
                                double d2 = xcenter + (double)(xoffset + j) / resolution;
                                double d3 = 0.0;
                                double d4 = 0.0;
                                double d5 = 0.0;
                                double d6 = 0.0;
                                double d7 = 0.0;
                                for (n3 = 0; n3 < maxiter && d7 <= 4.0; ++n3) {
                                    d5 = d3 * d3 - d4 * d4 + d2;
                                    d6 = 2.0 * d3 * d4 + d;
                                    d7 = d5 * d5 + d6 * d6;
                                    d3 = d5;
                                    d4 = d6;
                                }
                                int n4 = n3;
                                this.thr_histogram[n4] = this.thr_histogram[n4] + 1;
                            }
                        }
                    }

                    public void finish() {
                        histogram.reduce(this.thr_histogram, IntegerOp.SUM);
                    }
                });
            }
        });
        long l3 = System.currentTimeMillis();
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(outfile)));
        for (int i = 0; i <= maxiter; ++i) {
            printWriter.print(i);
            printWriter.print('\t');
            printWriter.print(histogram.get(i));
            printWriter.println();
        }
        printWriter.close();
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre");
        System.out.println(l3 - l2 + " msec calc");
        System.out.println(l4 - l3 + " msec post");
        System.out.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.nt=<K> edu.rit.smp.fractal.MSHistogramSmp2 <width> <height> <xcenter> <ycenter> <resolution> <maxiter> <outfile>");
        System.err.println("<K> = Number of parallel threads");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.err.println("<outfile> = Output file name");
        System.exit(1);
    }
}

