/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.fractal;

import edu.rit.color.HSB;
import edu.rit.image.PJGColorImage;
import edu.rit.image.PJGImage;
import edu.rit.pj.BarrierAction;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;
import edu.rit.util.Range;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;

public class MandelbrotSetSmp3 {
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static double gamma;
    static File filename;
    static int xoffset;
    static int yoffset;
    static int[][] matrix;
    static PJGColorImage image;
    static int[] huetable;
    static LinkedBlockingQueue<Range> queue;
    static ParallelSection computationSection;
    static ParallelSection ioSection;
    static long[] comp_thr_t1;
    static long[] comp_thr_t2;
    static long io_thr_t1;
    static long io_thr_t2;
    static ArrayList<Long>[] chunk_t1;
    static ArrayList<Long>[] chunk_t2;

    private MandelbrotSetSmp3() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        long l = System.currentTimeMillis();
        if (stringArray.length != 8) {
            MandelbrotSetSmp3.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        gamma = Double.parseDouble(stringArray[6]);
        filename = new File(stringArray[7]);
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        matrix = new int[height][width];
        image = new PJGColorImage(height, width, matrix);
        huetable = new int[maxiter + 1];
        for (n = 0; n < maxiter; ++n) {
            MandelbrotSetSmp3.huetable[n] = HSB.pack((float)Math.pow((double)n / (double)maxiter, gamma), 1.0f, 1.0f);
        }
        MandelbrotSetSmp3.huetable[MandelbrotSetSmp3.maxiter] = HSB.pack(1.0f, 1.0f, 0.0f);
        queue = new LinkedBlockingQueue();
        n = ParallelTeam.getDefaultThreadCount();
        comp_thr_t1 = new long[n];
        comp_thr_t2 = new long[n];
        chunk_t1 = new ArrayList[n];
        chunk_t2 = new ArrayList[n];
        for (int i = 0; i < n; ++i) {
            MandelbrotSetSmp3.chunk_t1[i] = new ArrayList();
            MandelbrotSetSmp3.chunk_t2[i] = new ArrayList();
        }
        computationSection = new ParallelSection(){

            public void run() throws Exception {
                new ParallelTeam().execute(new ParallelRegion(){

                    public void run() throws Exception {
                        int n = this.getThreadIndex();
                        final ArrayList<Long> arrayList = chunk_t1[n];
                        final ArrayList<Long> arrayList2 = chunk_t2[n];
                        MandelbrotSetSmp3.comp_thr_t1[n] = System.currentTimeMillis();
                        this.execute(0, height - 1, new IntegerForLoop(){

                            public void run(int n, int n2) throws Exception {
                                arrayList.add(System.currentTimeMillis());
                                for (int i = n; i <= n2; ++i) {
                                    int[] nArray = matrix[i];
                                    double d = ycenter + (double)(yoffset - i) / resolution;
                                    for (int j = 0; j < width; ++j) {
                                        int n3;
                                        double d2 = xcenter + (double)(xoffset + j) / resolution;
                                        double d3 = 0.0;
                                        double d4 = 0.0;
                                        double d5 = 0.0;
                                        double d6 = 0.0;
                                        double d7 = 0.0;
                                        for (n3 = 0; n3 < maxiter && d7 <= 4.0; ++n3) {
                                            d5 = d3 * d3 - d4 * d4 + d2;
                                            d6 = 2.0 * d3 * d4 + d;
                                            d7 = d5 * d5 + d6 * d6;
                                            d3 = d5;
                                            d4 = d6;
                                        }
                                        nArray[j] = huetable[n3];
                                    }
                                }
                                queue.put(new Range(n, n2));
                                arrayList2.add(System.currentTimeMillis());
                            }
                        }, BarrierAction.NO_WAIT);
                        MandelbrotSetSmp3.comp_thr_t2[n] = System.currentTimeMillis();
                    }
                });
                queue.put(new Range());
            }
        };
        ioSection = new ParallelSection(){

            public void run() throws Exception {
                Range range;
                io_thr_t1 = System.currentTimeMillis();
                PJGImage.Writer writer = image.prepareToWrite(new BufferedOutputStream(new FileOutputStream(filename)));
                while ((range = queue.take()).length() > 0) {
                    writer.writeRowSlice(range);
                }
                writer.close();
                io_thr_t2 = System.currentTimeMillis();
            }
        };
        long l2 = System.currentTimeMillis();
        new ParallelTeam(2).execute(new ParallelRegion(){

            public void run() throws Exception {
                this.execute(computationSection, ioSection);
            }
        });
        long l3 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec calc start");
        for (int i = 0; i < n; ++i) {
            System.out.println("\t" + (comp_thr_t1[i] - l) + " msec thread " + i + " start");
            for (int j = 0; j < chunk_t1[i].size(); ++j) {
                System.out.println("\t\t" + (chunk_t1[i].get(j) - l) + " msec chunk " + j + " start");
                System.out.println("\t\t" + (chunk_t2[i].get(j) - l) + " msec chunk " + j + " finish");
            }
            System.out.println("\t" + (comp_thr_t2[i] - l) + " msec thread " + i + " finish");
        }
        System.out.println(l3 - l + " msec calc finish");
        System.out.println(io_thr_t1 - l + " msec I/O start");
        System.out.println(io_thr_t2 - l + " msec I/O finish");
        System.out.println(l3 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.nt=<K> -Dpj.schedule=<schedule> edu.rit.smp.fractal.MandelbrotSetSmp3 <width> <height> <xcenter> <ycenter> <resolution> <maxiter> <gamma> <filename>");
        System.err.println("<K> = Number of computation processors");
        System.err.println("<schedule> = Parallel loop schedule");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.err.println("<gamma> = Used to calculate pixel hues");
        System.err.println("<filename> = PJG image file name");
        System.exit(1);
    }
}

