/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.vector;

import edu.rit.mp.Buf;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Range;
import edu.rit.vector.Vector2D;
import edu.rit.vector.Vector2DArrayDoubleBuf;
import java.nio.ByteBuffer;

class Vector2DArrayDoubleBuf_1
extends Vector2DArrayDoubleBuf {
    public Vector2DArrayDoubleBuf_1(Vector2D[] vector2DArray, Range range) {
        super(vector2DArray, range);
    }

    public double get(int n) {
        int n2 = this.myArrayOffset + (n >>> 1);
        if ((n & 1) == 0) {
            return this.myArray[n2].x;
        }
        return this.myArray[n2].y;
    }

    public void put(int n, double d) {
        int n2 = this.myArrayOffset + (n >>> 1);
        if ((n & 1) == 0) {
            this.myArray[n2].x = d;
        } else {
            this.myArray[n2].y = d;
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2;
        int n3 = this.myArrayOffset + (n >>> 1);
        for (n2 = n; n2 < this.myLength && byteBuffer.remaining() >= 16; n2 += 2) {
            Vector2D vector2D = this.myArray[n3];
            byteBuffer.putDouble(vector2D.x);
            byteBuffer.putDouble(vector2D.y);
            ++n3;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3;
        int n4 = this.myArrayOffset + (n >>> 1);
        int n5 = Math.min(n + n2, this.myLength);
        for (n3 = n; n3 < n5 && byteBuffer.remaining() >= 16; n3 += 2) {
            Vector2D vector2D = this.myArray[n4];
            vector2D.x = byteBuffer.getDouble();
            vector2D.y = byteBuffer.getDouble();
            ++n4;
        }
        return n3 - n;
    }
}

