/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train.validation.distance;

import edu.msu.cme.rdp.alignment.AlignmentMode;
import edu.msu.cme.rdp.alignment.pairwise.PairwiseAligner;
import edu.msu.cme.rdp.alignment.pairwise.PairwiseAlignment;
import edu.msu.cme.rdp.alignment.pairwise.ScoringMatrix;
import edu.msu.cme.rdp.alignment.pairwise.rna.DistanceModel;
import edu.msu.cme.rdp.alignment.pairwise.rna.IdentityDistanceModel;
import edu.msu.cme.rdp.alignment.pairwise.rna.OverlapCheckFailedException;
import edu.msu.cme.rdp.classifier.train.LineageSequence;
import edu.msu.cme.rdp.classifier.train.LineageSequenceParser;
import edu.msu.cme.rdp.classifier.train.validation.HierarchyTree;
import edu.msu.cme.rdp.classifier.train.validation.Taxonomy;
import edu.msu.cme.rdp.classifier.train.validation.TreeFactory;
import edu.msu.cme.rdp.readseq.stat.StdevCal;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class PairwiseSeqDistance {
    private static final char gapChar = '-';
    private ScoringMatrix scoringMatrix = ScoringMatrix.getDefaultNuclMatrix();
    private AlignmentMode mode = AlignmentMode.overlap;
    private boolean show_alignment = false;
    private static final Options options = new Options();
    private static DistanceModel dist = new IdentityDistanceModel();
    private HashMap<Taxonomy, ArrayList<Double>> distanceMap = new HashMap();
    private ArrayList<LineageSequence> seqList = new ArrayList();
    TreeFactory factory = null;

    public PairwiseSeqDistance(String trainseqFile, String taxFile, AlignmentMode mode, boolean show_alignment) throws IOException, OverlapCheckFailedException {
        this.mode = mode;
        this.show_alignment = show_alignment;
        this.factory = new TreeFactory(new FileReader(taxFile));
        LineageSequenceParser parser = new LineageSequenceParser(new File(trainseqFile));
        while (parser.hasNext()) {
            LineageSequence tmp = parser.next();
            this.seqList.add(tmp);
            this.factory.addSequence(parser.next());
        }
        parser.close();
        this.calDist();
    }

    private void calDist() throws OverlapCheckFailedException {
        HashMap<String, HierarchyTree> nodeMap = new HashMap<String, HierarchyTree>();
        HierarchyTree root = this.factory.getRoot();
        root.getNodeMap(this.factory.getLowestRank(), nodeMap);
        for (int i = 0; i < this.seqList.size(); ++i) {
            LineageSequence seqx = this.seqList.get(i);
            HierarchyTree treex = nodeMap.get(seqx.getAncestors().get(seqx.getAncestors().size() - 1));
            for (int j = i + 1; j < this.seqList.size(); ++j) {
                ArrayList<Double> distList;
                LineageSequence seqy = this.seqList.get(j);
                HierarchyTree treey = nodeMap.get(seqy.getAncestors().get(seqy.getAncestors().size() - 1));
                Taxonomy lowestCommonAnc = PairwiseSeqDistance.findLowestCommonAncestor(treex, treey);
                PairwiseAlignment result = PairwiseAligner.align((String)seqx.getSeqString().replaceAll("U", "T"), (String)seqy.getSeqString().replaceAll("U", "T"), (ScoringMatrix)this.scoringMatrix, (AlignmentMode)this.mode);
                double distance = dist.getDistance(result.getAlignedSeqj().getBytes(), result.getAlignedSeqi().getBytes(), 0);
                if (this.show_alignment) {
                    System.out.println(">\t" + seqx.getSeqName() + "\t" + seqy.getSeqName() + "\t" + String.format("%.3f", distance) + "\t" + lowestCommonAnc.getHierLevel());
                    System.out.println(result.getAlignedSeqi() + "\n");
                    System.out.println(result.getAlignedSeqj() + "\n");
                }
                if ((distList = this.distanceMap.get(lowestCommonAnc)) == null) {
                    distList = new ArrayList();
                    distList.add(distance);
                    this.distanceMap.put(lowestCommonAnc, distList);
                    continue;
                }
                distList.add(distance);
            }
        }
    }

    public void printSummary(PrintStream outStream) {
        StdevCal.Std result;
        HashMap rankDistanceMap = new HashMap();
        outStream.println("\nrank\ttaxonname\ttotalcount\tmean_distance\tstdev");
        for (Taxonomy taxon : this.distanceMap.keySet()) {
            result = StdevCal.calStd(this.distanceMap.get(taxon));
            outStream.println(taxon.getHierLevel() + "\t" + taxon.getName() + "\t" + result.getTotalCount() + "\t" + String.format("%.3f", result.getMean()) + "\t" + String.format("%.3f", result.getStdev()));
            ArrayList distList = (ArrayList)rankDistanceMap.get(taxon.getHierLevel());
            if (distList == null) {
                distList = new ArrayList();
                distList.addAll(this.distanceMap.get(taxon));
                rankDistanceMap.put(taxon.getHierLevel(), distList);
                continue;
            }
            distList.addAll(this.distanceMap.get(taxon));
        }
        outStream.println("\nrank\ttotalcount\tmean_distance\tstdev");
        for (String rank : rankDistanceMap.keySet()) {
            result = StdevCal.calStd((ArrayList)((ArrayList)rankDistanceMap.get(rank)));
            outStream.println(rank + "\t" + result.getTotalCount() + "\t" + String.format("%.3f", result.getMean()) + "\t" + String.format("%.3f", result.getStdev()));
        }
        outStream.close();
    }

    private static Taxonomy findLowestCommonAncestor(HierarchyTree treex, HierarchyTree treey) {
        HierarchyTree parent;
        ArrayList<HierarchyTree> ancestorx = new ArrayList<HierarchyTree>();
        ArrayList<HierarchyTree> ancestory = new ArrayList<HierarchyTree>();
        ancestorx.add(treex);
        for (parent = treex.getParent(); parent != null; parent = parent.getParent()) {
            ancestorx.add(parent);
        }
        ancestory.add(treey);
        for (parent = treey.getParent(); parent != null; parent = parent.getParent()) {
            ancestory.add(parent);
        }
        Taxonomy lowestCommonAnc = ((HierarchyTree)ancestorx.get(ancestorx.size() - 1)).getTaxonomy();
        for (int i = 2; i <= ancestorx.size() && ancestory.size() - i >= 0; ++i) {
            if (!((HierarchyTree)ancestorx.get(ancestorx.size() - i)).getTaxonomy().equals(((HierarchyTree)ancestory.get(ancestory.size() - i)).getTaxonomy())) continue;
            lowestCommonAnc = ((HierarchyTree)ancestorx.get(ancestorx.size() - i)).getTaxonomy();
        }
        return lowestCommonAnc;
    }

    public static void main(String[] args) throws Exception {
        String trainseqFile = null;
        String taxFile = null;
        PrintStream outStream = null;
        AlignmentMode mode = AlignmentMode.overlap;
        boolean show_alignment = false;
        try {
            CommandLine line = new PosixParser().parse(options, args);
            if (line.hasOption("show_alignment")) {
                show_alignment = true;
            }
            if (line.hasOption("alignment-mode")) {
                String m = line.getOptionValue("alignment-mode").toLowerCase();
                mode = AlignmentMode.valueOf((String)m);
            }
            if (args.length != 3) {
                throw new Exception("wrong arguments");
            }
            args = line.getArgs();
            trainseqFile = args[0];
            taxFile = args[1];
            outStream = new PrintStream(new File(args[2]));
        }
        catch (Exception e) {
            System.err.println("Command Error: " + e.getMessage());
            new HelpFormatter().printHelp(80, " [options] trainseqFile taxonFile outFile", "", options, "");
            return;
        }
        PairwiseSeqDistance theObj = new PairwiseSeqDistance(trainseqFile, taxFile, mode, show_alignment);
        theObj.printSummary(outStream);
    }

    static {
        options.addOption("a", "alignment-mode", true, "Alignment mode: overlap, glocal, local or global. default = overlap");
        options.addOption("w", "show_alignment", false, "if true, output the detailed alignment to stdout. default = false");
    }
}

