/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.unifrac;

import edu.msu.cme.rdp.classifier.ClassificationResult;
import edu.msu.cme.rdp.multicompare.MCSample;
import edu.msu.cme.rdp.taxatree.UnifracTree;
import edu.msu.cme.rdp.taxatree.VisitInfo;
import edu.msu.cme.rdp.taxatree.interfaces.TreeVisitor;
import edu.msu.cme.rdp.taxatree.utils.ClassifierTreeBuilder;
import edu.msu.cme.rdp.unifrac.UnifracTaxon;
import java.util.List;
import java.util.Map;

public class UnifracTreeBuilder {
    private ClassifierTreeBuilder builder;

    public UnifracTreeBuilder(List<ClassificationResult> classifications, Map<String, UnifracSample> sampleMap) {
        this(classifications, sampleMap, 0.0f);
    }

    public UnifracTreeBuilder(List<ClassificationResult> classifications, final Map<String, UnifracSample> sampleMap, float cutoff) {
        this.builder = new ClassifierTreeBuilder<UnifracTaxon>(new UnifracTree(), classifications, cutoff, new ClassifierTreeBuilder.ClassifierTaxonFactory<UnifracTaxon>(){

            @Override
            public UnifracTaxon buildTaxon(int taxid, String name, String rank, float conf, boolean unclassified) {
                float dist = 1.0f;
                if (rank.equals("sequence")) {
                    dist = 0.0f;
                }
                return new UnifracTaxon(taxid, name, rank, dist, unclassified);
            }
        });
        this.builder.getRoot().topDownVisit((TreeVisitor)new TreeVisitor<UnifracTaxon>(){

            public boolean visitNode(VisitInfo<UnifracTaxon> visitInfo) {
                UnifracTaxon taxon = (UnifracTaxon)visitInfo.getTaxon();
                if (sampleMap.containsKey(taxon.getName())) {
                    taxon.setSampleCount(((UnifracSample)sampleMap.get((Object)taxon.getName())).sample, ((UnifracSample)sampleMap.get((Object)taxon.getName())).count);
                }
                return true;
            }
        });
        ((UnifracTree)this.builder.getRoot()).refreshInnerTaxa();
    }

    public UnifracTree getUnifracTree() {
        return (UnifracTree)this.builder.getRoot();
    }

    public static class UnifracSample {
        public MCSample sample;
        public double count;
    }
}

