/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.pairwise.rna;

import edu.msu.cme.rdp.alignment.pairwise.rna.OverlapCheckFailedException;
import edu.msu.cme.rdp.readseq.utils.SeqUtils;

public class DivergenceMatrix {
    protected final int[] A = new int[]{0, 0};
    protected final int[] B = new int[]{1, 0};
    protected final int[] C = new int[]{2, 0};
    protected final int[] D = new int[]{4, 0};
    protected final int[] E = new int[]{0, 1};
    protected final int[] F = new int[]{1, 1};
    protected final int[] G = new int[]{2, 1};
    protected final int[] H = new int[]{4, 1};
    protected final int[] I = new int[]{0, 2};
    protected final int[] J = new int[]{1, 2};
    protected final int[] K = new int[]{2, 2};
    protected final int[] L = new int[]{4, 2};
    protected final int[] M = new int[]{0, 4};
    protected final int[] N = new int[]{1, 4};
    protected final int[] O = new int[]{2, 4};
    protected final int[] P = new int[]{4, 4};
    private static final int x = 0;
    private static final int y = 1;
    private double[][] matrix = new double[5][5];

    public DivergenceMatrix(byte[] seqX, byte[] seqY, int overlapLimit) throws OverlapCheckFailedException {
        int i;
        int matchablePositions = 0;
        double[][] localMatrix = new double[this.matrix.length][this.matrix.length];
        for (i = 0; i < seqX.length; ++i) {
            byte x = seqX[i];
            byte y = seqY[i];
            if ((x & SeqUtils.NON_COMPAREABLE) != 0 || (y & SeqUtils.NON_COMPAREABLE) != 0) continue;
            ++matchablePositions;
            double[] dArray = localMatrix[x >> 1];
            int n = y >> 1;
            dArray[n] = dArray[n] + 1.0;
        }
        if (matchablePositions < overlapLimit) {
            throw new OverlapCheckFailedException("did not pass the overlap limit");
        }
        for (i = 0; i < localMatrix.length; ++i) {
            for (int j = 0; j < localMatrix.length; ++j) {
                this.matrix[i][j] = localMatrix[i][j] / (double)matchablePositions;
            }
        }
    }

    public double getFrequency(int[] position) {
        return this.matrix[position[0]][position[1]];
    }
}

