	 IMPLICIT NONE
C 
C PROGRAM DESCRIPTION: 
C 
C	 Converts a GINO SAVDRA file into a sixel file suitable for importing
C	 into TeX via the /special{SX filename} command
C 
C AUTHORS: 
C 
C	 Sqn Ldr J P Baggott MBE MA CEng MIEE RAF
C 
C CREATION DATE: 	1 Dec 88
C 
C 
C	     C H A N G E   L O G
C 
C	 Date     | Name  | Description
C ----------------+-------+-----------------------------------------------------
C
C
C
	CHARACTER*4096	LINE		!Line buffer
	INTEGER*4	COUNT		!Number of chars in line
	INTEGER*4	START		!Start of outpur line in buffer
	INTEGER*4	ILLEGAL		!Position of illegal sequence in buffer
	INTEGER*4	STATE		!Window state retuned by WINENQ
	INTEGER*4	SEGMENT		!Segment number in saved drawing
	REAL*4		SAVEDWINDOW(4)	!Window bounds of saved drawing
	REAL*4		WIDTH		!Desired width
	REAL*4		HEIGHT		!Desired height
	REAL*4		SCALE		!Desired scale factor
	CHARACTER*255	INPUT		!Name of input file
	CHARACTER*255	OUTPUT		!Name of output file
	LOGICAL		FORMFEED	!Do we want a formfeed at the end of the
					!file?

	COMMON/GINOTOSIX/INPUT,OUTPUT,WIDTH,HEIGHT,SCALE,SEGMENT,FORMFEED

C	Get the parameters from the command line
	 
	CALL CLI

	CALL GINO
	
C	First use the dummy driver to find the window size of the saved drawing

	CALL DUMMY

	OPEN (UNIT=3,
	1   FILE = INPUT,
	1   STATUS = 'OLD',
	1   READONLY)

	CALL WINDOW(2)

	CALL GETDRA(3,SEGMENT,3,1)
	CALL WINENQ(STATE,1,4,SAVEDWINDOW)

	CALL DEVEND

C	Now open the LN03 driver and set up the transformations to rotate the
C	picture through 90 degrees and scale it to the user's desired size

	IF (HEIGHT.EQ.0.0) HEIGHT = SAVEDWINDOW(4)-SAVEDWINDOW(3)
	IF (WIDTH.EQ.0.0) WIDTH = SAVEDWINDOW(2)-SAVEDWINDOW(1)
	IF (SCALE.EQ.0.0) THEN
	    SCALE = WIDTH/(SAVEDWINDOW(2)-SAVEDWINDOW(1))
	    SCALE = MIN(SCALE,HEIGHT/(SAVEDWINDOW(4)-SAVEDWINDOW(3)))
	END IF
	
	OPEN (UNIT=1,
	1   FILE = 'GINOTOSIX.TMP',
	1   RECL = 4096,
	1   STATUS  = 'NEW')

	OPEN (UNIT=3,
	1   FILE = INPUT,
	1   STATUS = 'OLD',
	1   READONLY)

	CALL LN03

	CALL LINWID(0.2)
	CALL WINDO2(0.0,HEIGHT,0.0,WIDTH)
	CALL CHASWI(1)
	CALL SCALE2(SCALE,SCALE)
	CALL ROTAT2(90.0)
	CALL SHIFT2(-SAVEDWINDOW(1),-SAVEDWINDOW(4))
	CALL GETPIC(3,SEGMENT)
	CALL DEVEND

	CLOSE(3)

C	Next, open the sixel file produced by GINO, and prepare to filter it to
C	remove <ESC>c (printer reset), split lines longer than 256 bytes, and
C	remove the FORTRAN carriage controls 

	OPEN (UNIT=1,
	1   FILE = 'GINOTOSIX.TMP',
	1   STATUS  = 'OLD',
	1   DISPOSE = 'DELETE')

	OPEN (UNIT=2,
	1   FILE = OUTPUT,
	1   ACCESS	    = 'SEQUENTIAL',
	1   CARRIAGECONTROL = 'NONE',
	1   FORM	    = 'FORMATTED',
	1   RECORDTYPE	    = 'VARIABLE',
	1   RECL	    = 256,
	1   STATUS	    = 'NEW')
	
C	Repeat until end-of-file

	DO WHILE (.TRUE.)
	
	    READ (1,999,END=500) COUNT,LINE(1:COUNT)

C	    Remove all occurences of <ESC>c

	    ILLEGAL = INDEX(LINE(1:COUNT),CHAR(27)//'c')
	
	    DO WHILE (ILLEGAL.GT.0)
		IF (ILLEGAL.EQ.COUNT-1) THEN
		    IF (COUNT.GT.2) LINE(1:COUNT-2) = LINE(1:ILLEGAL-1)
		ELSE
		    LINE(1:COUNT-2) = LINE(1:ILLEGAL-1)//LINE(ILLEGAL+2:COUNT)
		END IF
		COUNT = COUNT-2
		IF (COUNT.GT.2) THEN
		    ILLEGAL = INDEX(CHAR(27)//'c',LINE(1:COUNT))
		ELSE
		    ILLEGAL = 0
		END IF
	    END DO

C	    Split lines longer than 256 bytes

	    START=1

	    DO WHILE (START.LE.COUNT.AND.COUNT.GT.0)
		WRITE(2,998)LINE(START:MIN(START+255,COUNT))
		START = START+256
	    END DO
	
	END DO

500	IF (FORMFEED) WRITE(2,997) '0C'X
	
C	Close the files and exit

	CLOSE(1)
	CLOSE(2)

	CALL GINEND

997	FORMAT(A1)
998	FORMAT(A)
999	FORMAT(X,Q,A)
	END
