import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;

/*
 * TalkListGUI.java
 *
 * Created on 14. December 2005, 10:23
 */

/**
 * This is a dialogue representing the complete list of talks.
 * Marked talks can be accessed by getSelectedt().
 *
 * @author  Olle Nebendahl
 */
public class TalkListGUI extends JDialog 
{

    static TalkListGUI tg;

    private JButton EditButton;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    
    public DefaultListModel myListModel;

    /** Creates new form TalkListGUI */

    public TalkListGUI(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        if(null==tg)
        {
            myListModel = new DefaultListModel();
            initComponents();
            update();
        }
        tg=this;
    }
    
    public void update()
    {
        myListModel.removeAllElements();
        int[] li = SlideConnection.getTalks();
        int l = li.length;
        int i = 0;
        while(i<l)
        {
            myListModel.addElement(TalkCache.getTalk(li[i]));
            i++;
        }
        pack();
    }
    
    private void initComponents() {
        jPanel1 = new JPanel();
        jPanel2 = new JPanel();
        jScrollPane1 = new JScrollPane();
        jList1 = new JList(myListModel);
        
        jList1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jListMouseClicked(evt);
            }
        });
        
        EditButton = new JButton();

        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.X_AXIS));

        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

        //jPanel1.setLayout(new BoxLayout(jPanel1, BoxLayout.X_AXIS));

        jScrollPane1.setPreferredSize(new java.awt.Dimension(260, 480));
        jScrollPane1.setViewportView(jList1);

        getContentPane().add(jScrollPane1);

        //jPanel2.setLayout(new BoxLayout(jPanel2, BoxLayout.Y_AXIS));

        EditButton.setText("edit");
        EditButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                EditButtonActionPerformed(evt);
            }
        });

        getContentPane().add(EditButton);

        pack();
    }
    
    public void setVisible(boolean b)
    {
        if(!b)
        {
            getLocation(Constants.prefTalkListGUICoordinates);
            Constants.savePreferences();
        }
        else setLocation(Constants.prefTalkListGUICoordinates);
        super.setVisible(b);
    }
    

    private void EditButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        doEdit();
    }
    
    private void doEdit()
    {
        int i = jList1.getSelectedIndex();
        if(-1==i)return;
        i=((TalkRecord)jList1.getSelectedValue()).getTalkId();
        final TalkEditGUI tag = new TalkEditGUI(new TalkWrapper(i));
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                tag.setVisible(true);
            }
        });
    }
    
    
    static TalkRecord getSelected()
    {
        if(null!=tg)
        {
            int i = tg.jList1.getSelectedIndex();
            if(-1==i)return null;
            return ((TalkRecord)tg.jList1.getSelectedValue());
        }
        else return null;
    }
    

    private void jListMouseClicked(java.awt.event.MouseEvent evt) 
    {
        int clickCount=evt.getClickCount();
        if(2==clickCount)
        {
            doEdit();
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) 
    {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new TalkListGUI(new JFrame(), false).setVisible(true);
            }
        });
        
        /*
        File file = new File(".");
        final JFileChooser fc = new JFileChooser(file);
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(new TalkListGUI(null,true));
        if(returnVal==JFileChooser.APPROVE_OPTION)
        {
            System.out.println(fc.getSelectedFile().toString());
            System.out.println((new File(fc.getSelectedFile(),"preferences.ini")).isFile());
        }*/
    }
}
