/* Output from p2c, the Pascal-to-C translator */
/* From input file "tp_m2tf2.pas" */


#define TP_M2TF4_G
#include "tp_m2tf4.h"
#include <stdlib.h>
#include <string.h>

/**************************************************/
Void ReadBlock(FilRec)
FileRecord *FilRec;
{
  /**************************************************/
  Char STR2[256];
  char 	*p;
  int 	ToBeRead,i;

  /* there is a request to read a block. If the EOF is reached exit */
  if (FilRec->LastBlockRead)
    ErrorExit(24L);
  fseek(MidiFile, FilRec->FilePosition, SEEK_SET);
  if (FilRec->BufSemaphore > 0) {
    memmove(FilRec->ReadBuf,FilRec->BufPoint,(size_t)FilRec->BufSemaphore);
    FilRec->BufPoint= FilRec->ReadBuf;
    p=FilRec->ReadBuf;
    for (i=1;i<=FilRec->BufSemaphore;i++){p++;}
  } else {
    FilRec->BufPoint = FilRec->ReadBuf;
    p=FilRec->ReadBuf;
    }
  ToBeRead=sizeof(BufType)-FilRec->BufSemaphore;
  FilRec->ReadIn = fread(p, 1,ToBeRead ,MidiFile);
  FilRec->BufSemaphore += (unsigned short)FilRec->ReadIn;
  if (Debug) {
    sprintf(STR2, "Read in: %ld", FilRec->ReadIn);
    WriteDebugInfo(STR2);
    sprintf(STR2, "Bufsemaphore : %d", FilRec->BufSemaphore);
    WriteDebugInfo(STR2);
  }
  if (FilRec->ReadIn < ToBeRead ) {
    FilRec->LastBlockRead = true;
    if (Debug)
      WriteDebugInfo("Read in last block in file");
  } else
    FilRec->LastBlockRead = false;
  FilRec->FilePosition = ftell(MidiFile) /* + 1 */;
}  /* ReadBlock */


/*************************************************/
uchar ReadByte(FilRec)
FileRecord *FilRec;
{
  /*************************************************/
  uchar Result;

  if (FilRec->BufSemaphore < 1)
    ReadBlock(FilRec);
  memmove(&Result, FilRec->BufPoint,(size_t)1);
  FilRec->BufSemaphore--;
  FilRec->BufPoint++;
  FilRec->BytesProcessed++;
  FilRec->LastNoBytesRead = 1;
  if (!(FilRec->LastBlockRead==true && FilRec->BufSemaphore==0)) {
    FilRec->NoMoreData = false;
    return Result;
  }
  FilRec->NoMoreData = true;
  if (Debug)
    WriteDebugInfo("There are no more data");
  return Result;
}  /* ReadByte */


#ifndef ST
/*******************************************************/
long ReadLongInt(FilRec)
FileRecord *FilRec;
{
  /*******************************************************/
  long TmpLI, cnt;
  uchar b;

  if (FilRec->BufSemaphore < 4)
    ReadBlock(FilRec);
  TmpLI = 0;
  for (cnt = -1; cnt <= 2; cnt++) {
    memmove(&b, FilRec->BufPoint,(size_t)1);
    FilRec->BufPoint++;
    TmpLI = TmpLI * 256 + b;
  }
/* p2c: tp_m2tf2.pas, line 92: Note: Can't interpret size in MOVE [174] */
  FilRec->BufSemaphore -= 4;
  FilRec->BytesProcessed += 4;
  FilRec->LastNoBytesRead = 4;
  if (!(FilRec->LastBlockRead==true && FilRec->BufSemaphore==0)) {
    FilRec->NoMoreData = false;
    return TmpLI;
  }
  FilRec->NoMoreData = true;
  if (Debug)
    WriteDebugInfo("There are no more data");
  return TmpLI;
}  /* ReadLongInt */


/*******************************************************/
long ReadInteger(FilRec)
FileRecord *FilRec;
{
  /*******************************************************/
  long TmpInt, cnt;
  uchar b;

  if (FilRec->BufSemaphore < 2)
    ReadBlock(FilRec);
  TmpInt = 0;
  for (cnt = -1; cnt <= 0; cnt++) {
    memmove((&b), (FilRec->BufPoint),(size_t)1);
    FilRec->BufPoint++;
    TmpInt = TmpInt * 256 + b;
  }
  FilRec->BufSemaphore -= 2;
  FilRec->BytesProcessed += 2;
  FilRec->LastNoBytesRead = 2;
  if (!(FilRec->LastBlockRead==true && FilRec->BufSemaphore==0)) {
    FilRec->NoMoreData = false;
    return TmpInt;
  }
  FilRec->NoMoreData = true;
  if (Debug)
    WriteDebugInfo("There are no more data");
  return TmpInt;
}  /* ReadInteger */
#endif


#ifdef ST
/*******************************************************/
long ReadInteger(FilRec)
FileRecord *FilRec;
{
  /*******************************************************/
  long TmpInt;

  if (FilRec->BufSemaphore < 2)
    ReadBlock(FilRec);
  memmove((&TmpInt), (&FilRec->ReadBuf[FilRec->BufPoint - 1]),
	  sizeof(uchar));
  FilRec->BufSemaphore -= 2;
  FilRec->BufPoint += 2;
  FilRec->BytesProcessed += 2;
  FilRec->LastNoBytesRead = 2;
  if (!(FilRec->LastBlockRead==true && FilRec->BufSemaphore==0)) {
    FilRec->NoMoreData = false;
    return TmpInt;
  }
  FilRec->NoMoreData = true;
  if (Debug)
    WriteDebugInfo("There are no more data");
  return TmpInt;
}  /* ReadInteger */


/*******************************************************/
long ReadLongInt(FilRec)
FileRecord *FilRec;
{
  /*******************************************************/
  long TmpLI;

  if (FilRec->BufSemaphore < 4)
    ReadBlock(FilRec);
  memmove((&TmpLI), (&FilRec->ReadBuf[FilRec->BufPoint - 1]),
	  sizeof(uchar) * 2L);
  FilRec->BufPoint += 4;
  FilRec->BufSemaphore -= 4;
  FilRec->BytesProcessed += 4;
  FilRec->LastNoBytesRead = 4;
  if (!(FilRec->LastBlockRead==true && FilRec->BufSemaphore==0)) {
    FilRec->NoMoreData = false;
    return TmpLI;
  }
  FilRec->NoMoreData = true;
  if (Debug)
    WriteDebugInfo("There are no more data");
  return TmpLI;
}  /* ReadLongInt */
#endif

/******************************************************/
long ReadVarLen(FilRec)
FileRecord *FilRec;
{
  /******************************************************/
  long Result, Tmp;
  uchar Bt, Cnt;

  Cnt = 1;
  Tmp = 0;
  Bt = ReadByte(FilRec);

  if ((Bt & 0x80) > 0) {
    do {
      Bt &= 0x7f;
      Tmp += Bt;
      Tmp <<= 7;
      Bt = ReadByte(FilRec);
      Cnt++;
    } while ((Bt & 0x80) != 0);
    Tmp += Bt;
  } else
    Tmp = Bt;

  Result = Tmp;
  FilRec->LastNoBytesRead = Cnt;
  return Result;
}  /* ReadVarLen */


/*******************************************************************/
Char *ReadString(Char *Result, FileRecord *FilRec, long len)
{
  /*******************************************************************/
  Char TmpStr[81];
  int	i;
  if (FilRec->BufSemaphore < len)
    ReadBlock(FilRec);
  TmpStr[len] = '\0';
  memmove(&TmpStr, (FilRec->BufPoint), (size_t)len);
  FilRec->BufSemaphore -= (unsigned short)len;
  for (i=0;i<len;i++) FilRec->BufPoint++;
  FilRec->BytesProcessed += len;
  FilRec->LastNoBytesRead = (unsigned short)len;
  if (!(FilRec->LastBlockRead==true && FilRec->BufSemaphore==0)) {
    FilRec->NoMoreData = false;
    strcpy(Result, TmpStr);
    return Result;
  }
  FilRec->NoMoreData = true;
  if (Debug)
    WriteDebugInfo("There are no more data");
  strcpy(Result, TmpStr);
  return Result;
}  /* ReadString */


/*******************************************         */
/* Void C2Pstring(Char *Cstr)                        */
/* {                                                 */
/*****************************************           */
/*   uchar nilpos;                                   */
/*                                                   */
/*   Cstr['P'] = '\0';                               */
/*   nilpos = strpos2(Cstr, "\0", 1);                */
/*   Cstr[nilpos] = '\0';                            */
/* p2c: tp_m2tf2.pas, line 258:                      */
/*  * Note: Modification of string length may translate incorrectly [146] */
/* }                                                 */ 
/* C2Pstring */


/********************************************/
Void P2Cstring(Pstr)
Char *Pstr;
{
  /********************************************/
#ifdef __unix
  size_t L;
#else
  uchar L;
#endif
  int TEMP;

  L = strlen(Pstr);
  TEMP = strlen(Pstr);
  memmove(&TEMP, Pstr, (size_t)L);
  Pstr[L - 1] = '\0';
}  /* C2Pstring */


/*****************************************************/
  long GetFilePos(FilRec)
/*****************************************************/
FileRecord *FilRec;
{
  /* return ((ftell(MidiFile) + 1) / 500 + FilRec->BufPoint - 1); */
  return (ftell(MidiFile) /* + 1 */) ;
}


/***********************************************************      */
/* Void SetFilePos(FileRecord *FilRec, long Pst)                  */
/* {                                                              */
/***********************************************************      */
/*   fseek(MidiFile, Pst - 1, SEEK_SET);                          */
/*   FilRec->BufPoint = BufSize_;                                 */
/*   FilRec->BufSemaphore = 0;                                    */
/*   ReadBlock(FilRec);                                           */
/* }                                                              */
/***********************************************************      */



/************************************************************/
Void InitFilRec(FileRecord *FilRec)
{
  /************************************************************/
  FilRec->ReadBuf = (char *)malloc(sizeof(BufType));
  if (FilRec->ReadBuf==NULL) ErrorExit(9L);
  memset(FilRec->ReadBuf,'\0', sizeof(BufType));
  FilRec->BufPoint = FilRec->ReadBuf;
}


/************************************************************/
Void KillFilRec(FileRecord *FilRec)
{
  /************************************************************/
/* p2c: tp_m2tf2.pas, line 314:
 * Warning: Too many arguments for freemem [299] */
  free(FilRec->ReadBuf);
}


/************************************************************/
Void RestoreLastRead(FileRecord *FilRec)
{
  /************************************************************/
  FilRec->BufPoint -= FilRec->LastNoBytesRead;
  FilRec->BytesProcessed -= FilRec->LastNoBytesRead;
  FilRec->BufSemaphore += FilRec->LastNoBytesRead;
}


void _TP_M2TF4_init()
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
}
