/****************************************************************************
  PROJECT: FlowerSoft C++ library
  FILE   : string.h
--*/
#ifndef __STRiNG_H
#define __STRiNG_H

#ifndef __SORTABLE_H
#include "sortable.h"
#endif

/****************************************************************************
  class StringData
--*/

class String;

class StringData {
friend class String;

    int length;
    char* string;
    int references;
    
    StringData();
};
//-- class StringData //

/****************************************************************************
  class String
--*/

class String : public Sortable {
protected:
    StringData* data;

public:
    virtual int operator ==( const Sortable& test ) const;
    virtual int operator &&( const Object& test ) const;
    virtual int operator >( const Sortable& test ) const;

    String& operator +( const String& s2 );
    String& operator +( const char* s2 );
    String& operator +( const char c );
//    friend String operator +( const char* s1, const String& s2 );
//    friend String operator +( const char c, const String& s2 );
//    friend String operator +( const String& s1, const String& s2 );
    void operator =( const String& source );
//    void operator =( const char* source );
    void operator +=( const char* source );
    void operator +=( const char c );

    virtual operator const char *() const;  
    virtual void operator ()( char* copy ) const;
    virtual char& operator []( const int n );
    virtual const char& operator []( const int n ) const;
  
    int  compare( const char* s ) const;
//    double fvalue() const;  
    int lastPos( const char c) const;
    int lastPos( const char* string ) const;
    inline int len() const;
    String left( const int n ) const;
    String& lower();
    String mid( const int pos, const int n ) const;
    String nomid( const int pos, const int n ) const;
    int pos( const char c ) const; 
    int pos( const char* string ) const;
    int posAny( const char* string ) const;
    inline virtual void printOn( ostream& os ) const;
    String right( const int n ) const;
    String& upper();
    long value() const;

    String();                  // String s;
                               // String s = "abc";
    String( const char* source ); 
    String( const String& s ); // String s = String ...;
                               // String s( ' ', 80 );
    String( const char c, const int n = 1 );
    String( const int i );     // String s( 10 );
                               // String s( 3.14, 6, '#' );
    String( const int i, const int n, const char c = ' ' );
    virtual ~String();
};
//-- class String //

/****************************************************************************
  class StringData
--*/

#if 1
#define __STRINGDATA__STRINGDATA
inline StringData::StringData()
{
    length = 0;
    references = 1;
    string = 0;
}
#endif

/****************************************************************************
  class String
--*/

#if 1
#define __STRING_STRING
inline String::String()
{
    data = new StringData;
}
#endif

inline int String::len() const 
{ 
    return ( ( data->string && *data->string ) ? data->length - 1 : 0 );
} 

inline void String::printOn( ostream& os ) const
{
    os << (const char*)*this;
}

inline int operator ==( const char* test1, const String& test2 )
{
    return test2.compare( test1 );
}

inline int operator ==( const String& test1, const char* test2 )
{
    return test1.compare( test2 );
}
//-- class String //

#endif // __STRiNG_H //
