/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sourceforge.texlipse.TexlipsePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathUtils {
    private PathUtils() {
    }

    public static String[] mergeEnvFromPrefs(Properties envProp, String prefName) {
        HashMap<String, String> environment = new HashMap<String, String>();
        Enumeration<Object> e = envProp.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String v = envProp.getProperty(key);
            environment.put(key, v);
        }
        Map<String, String> prefsMap = PathUtils.getPreferenceMap(prefName);
        String[] keys = prefsMap.keySet().toArray(new String[0]);
        int i = 0;
        while (i < keys.length) {
            String value = prefsMap.get(keys[i]);
            value = PathUtils.replaceVar(envProp, value);
            environment.put(keys[i], value);
            ++i;
        }
        return PathUtils.getStrings(environment);
    }

    private static String replaceVar(Properties envProp, String str) {
        return str;
    }

    public static String[] getStrings(Map<String, String> map) {
        String[] array = new String[map.size()];
        String[] keys = map.keySet().toArray(new String[0]);
        int i = 0;
        while (i < keys.length) {
            array[i] = String.valueOf(keys[i]) + '=' + map.get(keys[i]);
            ++i;
        }
        return array;
    }

    public static Map<String, String> getPreferenceMap(String name) {
        HashMap<String, String> map = new HashMap<String, String>();
        String str = TexlipsePlugin.getPreference(name);
        if (str == null) {
            return map;
        }
        String[] binds = str.split(",");
        if (binds == null) {
            return map;
        }
        int i = 0;
        while (i < binds.length) {
            int index = binds[i].indexOf(61);
            if (index > 0) {
                map.put(binds[i].substring(0, index), binds[i].substring(index + 1));
            }
            ++i;
        }
        return map;
    }

    public static String[] getStrings(Properties prop) {
        String[] env = new String[prop.size()];
        int i = 0;
        Enumeration<Object> enumeration = prop.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            env[i++] = String.valueOf(key) + '=' + prop.getProperty(key);
        }
        return env;
    }

    public static void tokenizeEscapedString(String args, List<String> list) {
        StringTokenizer st = new StringTokenizer(args, " ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.charAt(0) == '\"' && token.charAt(token.length() - 1) == '\"') {
                list.add(token.substring(1, token.length() - 1));
                continue;
            }
            if (token.charAt(0) == '\"') {
                StringBuffer sb = new StringBuffer();
                sb.append(token.substring(1));
                token = st.nextToken();
                while (!token.endsWith("\"") && st.hasMoreTokens()) {
                    sb.append(' ');
                    sb.append(token);
                    token = st.nextToken();
                }
                sb.append(' ');
                sb.append(token.substring(0, token.length() - 1));
                list.add(sb.toString());
                continue;
            }
            list.add(token);
        }
    }

    public static String getEnvPath(String bin) {
        Properties prop = PathUtils.getEnv();
        String path = prop.getProperty(PathUtils.findPathKey(prop));
        if (path == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String latexPath = st.nextToken();
            File latex = new File(String.valueOf(latexPath) + bin);
            if (!latex.exists() || !latex.isFile()) continue;
            return latexPath;
        }
        return null;
    }

    public static String findEnvFile(String file, String path, String winFile, String winPath) {
        File envFile;
        String envPath;
        String defaultFile = file;
        String defaultPath = path;
        if (System.getProperty("os.name").indexOf("indow") > 0) {
            defaultPath = winPath;
            defaultFile = winFile;
        }
        if ((envPath = PathUtils.getEnvPath(String.valueOf(File.separator) + defaultFile)) == null) {
            envPath = defaultPath;
        }
        if ((envFile = new File(envPath, defaultFile)).exists()) {
            return envFile.getAbsolutePath();
        }
        return "";
    }

    public static String findInEnvPath(String file, String path, String winFile, String winPath) {
        String envPath;
        String defaultFile = file;
        String defaultPath = path;
        if (System.getProperty("os.name").indexOf("indow") > 0) {
            defaultPath = winPath;
            defaultFile = winFile;
        }
        if ((envPath = PathUtils.getEnvPath(String.valueOf(File.separator) + defaultFile)) == null) {
            envPath = defaultPath;
        }
        return envPath;
    }

    public static Properties getEnv() {
        Properties envVars = new Properties();
        try {
            String os = System.getProperty("os.name").toLowerCase();
            Process p = null;
            Runtime r = Runtime.getRuntime();
            if (os.indexOf("windows 9") > -1) {
                p = r.exec("command.com /c set");
                PathUtils.loadEscaping(envVars, p.getInputStream());
            } else if (os.indexOf("windows") > -1) {
                p = r.exec("cmd.exe /c set");
                PathUtils.loadEscaping(envVars, p.getInputStream());
            } else {
                p = r.exec("env");
                envVars.load(p.getInputStream());
            }
            p.waitFor();
        }
        catch (Exception exception) {}
        return envVars;
    }

    private static void loadEscaping(Properties prop, InputStream stream) throws IOException {
        int b;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((b = stream.read()) != -1) {
            bos.write(b);
        }
        StringTokenizer st = new StringTokenizer(bos.toString(), "\r\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf(61);
            if (index <= 0) continue;
            String key = token.substring(0, index);
            String value = token.substring(index + 1);
            prop.setProperty(key, value);
        }
    }

    public static String findPathKey(Properties prop) {
        Enumeration<Object> enumeration = prop.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.toLowerCase().equals("path")) continue;
            return key;
        }
        return "PATH";
    }
}

