/*-
******************************************************************************
******************************************************************************
**
**  ARCHIVE HEADER INFORMATION
**
**  @C-file{
**      FILENAME    = "machine.h",
**      VERSION     = "1.00",
**      DATE        = "",
**      TIME        = "",
**
**      AUTHOR      = "Niel Kempson",
**      ADDRESS     = "25 Whitethorn Drive
**                     Cheltenham
**                     GL52 5LL
**                     England",
**      TELEPHONE   = "+44-242 579105",
**      EMAIL       = "kempson@tex.ac.uk (Internet)",
**
**      SUPPORTED   = "yes",
**      ARCHIVED    = "tex.ac.uk, ftp.tex.ac.uk",
**      KEYWORDS    = "VVcode",
**
**      CODETABLE   = "ISO/ASCII",
**      CHECKSUM    = "51492 1481 5732 57976",
**
**      DOCSTRING   = { This file is part of VVcode.
**                  }
**  }
**
**  MODULE CONTENTS
**
**      [tbs]
**
**  COPYRIGHT
**
**      Written 1991-1992 by Niel Kempson <kempson@tex.ac.uk> who claims
**      no copyright over this program - you are free to use it as you wish.
**
**  CHANGE LOG
**
******************************************************************************
******************************************************************************
*/

/*-
******************************************************************************
******************************************************************************
**
** MACROS TO BE DEFINED
**
** For each of the operating environments, the macros listed below must be
** defined.  For full details of the meaning of these macros, see the file
** porting.doc that comes with vvcode.
**
** VVcode Environment
**
**  VV_OPERATING_SYSTEM
**  VV_IMPLEMENTATION
**  ANSI_SYNTAX
**
** Command Line Interface
**
**  QUAL_INTRO
**  QUAL_SEP
**  OPTIONAL_QUALIFIER_VALUES
**  STICKY_DEFAULTS
**  STDOUT_OUTPUT
**  SUPPORT_PIPING
**  STDIO_SYMBOL
**
** File Specifications
**
**  MAX_PATH
**  MAX_PREAMBLE
**  MAX_NAME
**  MAX_EXT
**  MAX_POSTAMBLE
**  PREAMBLE_END
**  EXTENSION_BEGIN
**  POSTAMBLE_BEGIN
**  UPPERCASE_FILESYSTEM
**  LEGAL_FILESPEC_CHARS
**  REPLACEMENT_FILESPEC_CHAR
**
** File Formats
**
**  SUPPORT_FIXED_FMT
**  SUPPORT_STREAM_FMT
**  SUPPORT_VARIABLE_FMT
**  TEXT_LINE_OVERHEAD
**
**  DEF_MODE
**  DEF_TEXT_FMT
**  DEF_BINARY_FMT
**
**  MIN_VARIABLE_RECORD_LEN
**  MAX_VARIABLE_RECORD_LEN
**  DEF_VARIABLE_RECORD_LEN
**
**  MIN_FIXED_RECORD_LEN
**  MAX_FIXED_RECORD_LEN
**  DEF_FIXED_RECORD_LEN
**
**  DEF_TEXT_PADCHAR
**  DEF_BINARY_PADCHAR
**
******************************************************************************
******************************************************************************
*/


/*-
******************************************************************************
******************************************************************************
**
** COMPILERS AND ENVIRONMENTS SUPPORTED
**
**      The compilers and environments supported are summarized here.  More
**      details are provided under the header comment for each environment.
**
**  MS-DOS 
**      MS-DOS, PC-DOS v3.2, v3.3, v4.01, v5.00
**
**          Borland Turbo C v1.5, v2.0
**          Borland Turbo C++ v1.0, v2.0, v3.0
**          Microsoft C v5.1, v6.0
**
**  OS/2
**      IBM OS/2 v2.0
**
**          GNUC C v2.1 with EMX v0.8c or later
**          Microsoft C v6.0
**          IBM C Set/2 v1.0
**
**  UNIX
**      BSD 4.1, BSD 4.2, BSD 4.3, System V
**
**          GNU C v1.38
**          native cc
**
**  VAX/VMS 
**      v5.1 - v5.4-1
**
**          GNU C v1.38
**          VMS cc v3
**
**  VM/CMS
**      version ?
**
**          Waterloo C version ?
**
******************************************************************************
******************************************************************************
*/


#ifdef  FALSE
# undef  FALSE
#endif
#define FALSE                   0

#ifdef  TRUE
# undef  TRUE
#endif
#define TRUE                    1


/*
**============================================================================
** OS_MSDOS
**
**  Definitions for the Microsoft MS/PC-DOS operating system used on the IBM
**  PC and compatibles.  The compilers supported are:
**
**      Borland Turbo C v1.5, v2.0          MSDOS_TURBOC
**      Borland Turbo C++ v1.0, v2.0, v3.0  MSDOS_TURBOC
**      Microsoft C v5.1                    MSDOS_MSC
**      Microsoft C v6                      MSDOS_MSC
**
**============================================================================
*/
#if (OS_MSDOS)

/*
**----------------------------------------------------------------------------
** VVCODE ENVIRONMENT
**
**  Both MS-DOS C compilers support the ANSI standard.
**  The MS-DOS implementation of VVCODE does not act as a filter.
**----------------------------------------------------------------------------
*/
# define VV_OPERATING_SYSTEM        "MS-DOS"

# if (MSDOS_TURBOC)
#  define VV_IMPLEMENTATION         "MS-DOS Turbo-C"
#  define ANSI_SYNTAX               TRUE
# endif                         /* (MSDOS_TURBOC) */

# if (MSDOS_MSC)
#  define VV_IMPLEMENTATION         "MS-DOS Microsoft C"
#  define ANSI_SYNTAX               TRUE
# endif                         /* (MSDOS_MSC) */

/*-
**----------------------------------------------------------------------------
** INCLUDE FILES
**----------------------------------------------------------------------------
*/
# include <stddef.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <dos.h>
# include <errno.h>
# include <sys/types.h>
# include <sys/stat.h>
# include <time.h>

# if (MSDOS_TURBOC)
#  include <alloc.h>
# endif                         /* (MSDOS_TURBOC) */

# if (MSDOS_MSC)
#  include <malloc.h>
# endif                         /* (MSDOS_MSC) */

/*
**----------------------------------------------------------------------------
** COMMAND LINE PARSING
**
**  MS-DOS qualifiers are usually introduced with a '/' and values separated
**  with an '='.  A typical command line would be:
**
**      program  /qualifier  file1  /qual=VALUE  file2
**----------------------------------------------------------------------------
*/
# define QUAL_INTRO                 "/-"
# define QUAL_SEP                   "=:-"
# define OPTIONAL_QUALIFIER_VALUES  TRUE
# define STICKY_DEFAULTS            TRUE
# define STDOUT_OUTPUT              FALSE
# define SUPPORT_PIPING             TRUE
# define STDIO_SYMBOL               "-"

/*
**----------------------------------------------------------------------------
** FILE SPECIFICATIONS
**
**  The general MS-DOS file specification has the form:
**
**          \\node\dir1\dir2\name.ext
**          device:\dir1\dir2\name.ext
**
**  The preamble is terminated by one of ':' or '\'.
**  There is no postamble.
**----------------------------------------------------------------------------
*/
# define MAX_PATH                   80
# define MAX_PREAMBLE               64
# define MAX_NAME                   8
# define MAX_EXT                    4
# define MAX_POSTAMBLE              0

# define PREAMBLE_END               ":\\"
# define EXTENSION_BEGIN            '.'
# define POSTAMBLE_BEGIN            ""
# define UPPERCASE_FILESYSTEM       TRUE

# define LEGAL_FILESPEC_CHARS \
 "@#$%^&-_=+abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890"
# define REPLACEMENT_FILESPEC_CHAR  '_'

/*
**----------------------------------------------------------------------------
** FILE FORMATS
**
**  MS-DOS has a stream file system and does not support the different file
**  formats - they are all written as stream files.  Text and binary files are
**  written differently.
**----------------------------------------------------------------------------
*/
# define SUPPORT_FIXED_FMT          TRUE
# define SUPPORT_STREAM_FMT         TRUE
# define SUPPORT_VARIABLE_FMT       TRUE

# define TEXT_LINE_OVERHEAD         1

# define DEF_MODE                   MODE_BINARY
# define DEF_TEXT_FMT               FMT_STREAM
# define DEF_BINARY_FMT             FMT_STREAM

# define MIN_VARIABLE_RECORD_LEN    1
# define MAX_VARIABLE_RECORD_LEN    32765
# define DEF_VARIABLE_RECORD_LEN    80

# define MIN_FIXED_RECORD_LEN       1
# define MAX_FIXED_RECORD_LEN       32767
# define DEF_FIXED_RECORD_LEN       512

# define DEF_TEXT_PADCHAR            ' '
# define DEF_BINARY_PADCHAR          0


#endif                          /* (OS_MSDOS) */



/*
**============================================================================
** OS_OS2
**
**  Definitions for the IBM OS/2 operating system used on the IBM PC and 
**  compatibles.  The compilers supported are:
**
**      GNUC C v2.1 with EMX                OS2_GNUC
**      IBM C Set/2                         OS2_CSET
**      Microsoft C v6                      OS2_MSC
**
**============================================================================
*/
#if (OS_OS2)

/*
**----------------------------------------------------------------------------
** VVCODE ENVIRONMENT
**
**  All three OS/2 C compilers support the ANSI standard.
**  The OS/2 implementation of VVCODE does not act as a filter.
**----------------------------------------------------------------------------
*/
# define VV_OPERATING_SYSTEM        "OS/2"

# if (OS2_CSET)
#  define VV_IMPLEMENTATION         "OS/2 IBM C Set/2"
#  define ANSI_SYNTAX               TRUE
# endif                         /* (OS2_CSET) */

# if (OS2_GNUC)
#  define ANSI_SYNTAX               TRUE
#  if (OS2_EMXGNUC)
#   define VV_IMPLEMENTATION        "OS/2 EMX/GNU C"
#  else	    	    	    	/* NOT (OS2_EMXGNUC) */
#   define VV_IMPLEMENTATION        "OS/2 GNU C"
#  endif                        /* (OS2_EMXGNUC) */
# endif                         /* (OS2_GNUC) */

# if (OS2_MSC)
#  define VV_IMPLEMENTATION         "OS/2 Microsoft C"
#  define ANSI_SYNTAX               TRUE
# endif                         /* (OS2_MSC) */

/*-
**----------------------------------------------------------------------------
** INCLUDE FILES
**----------------------------------------------------------------------------
*/
# include <stddef.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <errno.h>
# include <sys/types.h>
# include <sys/stat.h>
# include <time.h>

/*
**----------------------------------------------------------------------------
** COMMAND LINE PARSING
**
**  OS/2 qualifiers are usually introduced with a '/' and values separated
**  with an '='.  A typical command line would be:
**
**      program  /qualifier  file1  /qual=VALUE  file2
**----------------------------------------------------------------------------
*/
# define QUAL_INTRO                 "/-"
# define QUAL_SEP                   "=:-"
# define OPTIONAL_QUALIFIER_VALUES  TRUE
# define STICKY_DEFAULTS            TRUE
# define STDOUT_OUTPUT              FALSE
# define SUPPORT_PIPING             TRUE
# define STDIO_SYMBOL               "-"

/*
**----------------------------------------------------------------------------
** FILE SPECIFICATIONS
**
**  The general OS/2 file specification has the form:
**
**          \\node\dir1\dir2\name.ext
**          device:\dir1\dir2\name.ext
**
**  The preamble is terminated by one of ':' or '\'.
**  There is no postamble.
**----------------------------------------------------------------------------
*/
# define MAX_PATH                   80
# define MAX_PREAMBLE               64
# define MAX_NAME                   8
# define MAX_EXT                    4
# define MAX_POSTAMBLE              0

# define PREAMBLE_END               ":\\"
# define EXTENSION_BEGIN            '.'
# define POSTAMBLE_BEGIN            ""
# define UPPERCASE_FILESYSTEM       TRUE

# define LEGAL_FILESPEC_CHARS \
 "@#$%^-_=+abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890"
# define REPLACEMENT_FILESPEC_CHAR  '_'

/*
**----------------------------------------------------------------------------
** FILE FORMATS
**
**  OS/2 has a stream file system and does not support the different file
**  formats - they are all written as stream files.  Text and binary files are
**  written differently.
**----------------------------------------------------------------------------
*/
# define SUPPORT_FIXED_FMT          FALSE
# define SUPPORT_STREAM_FMT         TRUE
# define SUPPORT_VARIABLE_FMT       FALSE

# define TEXT_LINE_OVERHEAD         1

# define DEF_MODE                   MODE_BINARY
# define DEF_TEXT_FMT               FMT_STREAM
# define DEF_BINARY_FMT             FMT_STREAM

# define MIN_VARIABLE_RECORD_LEN    INV_RECORD_LEN
# define MAX_VARIABLE_RECORD_LEN    INV_RECORD_LEN
# define DEF_VARIABLE_RECORD_LEN    INV_RECORD_LEN

# define MIN_FIXED_RECORD_LEN       INV_RECORD_LEN
# define MAX_FIXED_RECORD_LEN       INV_RECORD_LEN
# define DEF_FIXED_RECORD_LEN       INV_RECORD_LEN

# define DEF_TEXT_PADCHAR           ' '
# define DEF_BINARY_PADCHAR         0

#endif                          /* (OS_OS2) */



/*
**============================================================================
** OS_UNIX
**
**  Definitions for the Unix operating system.  The variants of Unix &
**  compilers supported are:
**
**      BSD 4.1 Unix                            UNIX_BSD41, UNIX_BSD
**      BSD 4.2 Unix                            UNIX_BSD42, UNIX_BSD
**      BSD 4.3 Unix                            UNIX_BSD43, UNIX_BSD
**      Unix system V                           UNIX_SYSV
**      SCO Unix system V                       UNIX_SYSV
**
**      The GNU C compiler                      UNIX_GNUC
**      The Microsoft C compiler (on SCO Unix)  UNIX_MSC
**============================================================================
*/
#if (OS_UNIX)

/*
**----------------------------------------------------------------------------
** VVCODE ENVIRONMENT
**
**  The standard Berkeley C compiler does not support the ANSI standard.
**  The Unix implementation of VVCODE acts as a filter.
**----------------------------------------------------------------------------
*/
# define VV_OPERATING_SYSTEM        "UNIX"

# if (UNIX_BSD41)
#  define VV_IMPLEMENTATION         "BSD 4.1 Unix"
# endif                         /* (UNIX_BSD41) */

# if (UNIX_BSD42)
#  define VV_IMPLEMENTATION         "BSD 4.2 Unix"
# endif                         /* (UNIX_BSD42) */

# if (UNIX_BSD43)
#  define VV_IMPLEMENTATION         "BSD 4.3 Unix"
# endif                         /* (UNIX_BSD43) */

# if (UNIX_SYSV)
#  define VV_IMPLEMENTATION         "Unix System V"
# endif                         /* (UNIX_SYSV) */

# if (UNIX_GNUC || UNIX_MSC)
#  define ANSI_SYNTAX               TRUE
# else                          /* NOT (UNIX_GNUC || UNIX_MSC) */
#  define ANSI_SYNTAX               FALSE
# endif                         /* (UNIX_GNUC || UNIX_MSC) */

/*-
**----------------------------------------------------------------------------
** INCLUDE FILES
**----------------------------------------------------------------------------
*/
# if (ANSI_SYNTAX)
#  include <stdlib.h>
# endif                         /* (ANSI_SYNTAX) */

# if (UNIX_STRINGS_H)
#  include <strings.h>
# else                          /* NOT (UNIX_STRINGS_H) */
#  include <string.h>
# endif                         /* (UNIX_STRINGS_H) */

# include <errno.h>
# include <ctype.h>
# include <sys/types.h>
# include <sys/stat.h>
# include <time.h>

/*
**----------------------------------------------------------------------------
** COMMAND LINE INTERFACE
**
**  Unix qualifiers are usually introduced with a '-' and values separated
**  from the qualifier by whitespace.  A typical command line would be:
**
**      program  -overwrite file1 -mode binary file2
**----------------------------------------------------------------------------
*/
# define QUAL_INTRO                 "-"
# define QUAL_SEP                   " =:"
# define OPTIONAL_QUALIFIER_VALUES  FALSE
# define STICKY_DEFAULTS            FALSE
# define STDOUT_OUTPUT              TRUE
# define SUPPORT_PIPING             TRUE
# define STDIO_SYMBOL               "-"

/*
**----------------------------------------------------------------------------
** FILE SPECIFICATIONS
**
**  The general Unix file specification has the form:
**
**          node:/device/dir1/dir2/name.ext
**
**  The preamble is terminated by one of ':' or '/'.
**  There is no postamble.
**----------------------------------------------------------------------------
*/
# if (UNIX_BSD41)
#  define MAX_PATH                  255
#  define MAX_PREAMBLE              255
#  define MAX_NAME                  14
#  define MAX_EXT                   14
#  define MAX_POSTAMBLE             0
# endif                         /* (UNIX_BSD41) */

# if (UNIX_BSD42)
#  define MAX_PATH                  255
#  define MAX_PREAMBLE              255
#  define MAX_NAME                  255
#  define MAX_EXT                   255
#  define MAX_POSTAMBLE             0
# endif                         /* (UNIX_BSD42) */

# if (UNIX_BSD43)
#  define MAX_PATH                  1024
#  define MAX_PREAMBLE              1024
#  define MAX_NAME                  1024
#  define MAX_EXT                   1024
#  define MAX_POSTAMBLE             0
# endif                         /* (UNIX_BSD43) */

# if (UNIX_SYSV)
#  define MAX_PATH                  255
#  define MAX_PREAMBLE              255
#  define MAX_NAME                  14
#  define MAX_EXT                   14
#  define MAX_POSTAMBLE             0
# endif                         /* (UNIX_SYSV) */

# define PREAMBLE_END               ":/"
# define EXTENSION_BEGIN            '.'
# define POSTAMBLE_BEGIN            ""
# define UPPERCASE_FILESYSTEM       FALSE

# define LEGAL_FILESPEC_CHARS \
 ".@#$%^&-_=+abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890"
# define REPLACEMENT_FILESPEC_CHAR  '_'

/*
**----------------------------------------------------------------------------
** FILE FORMATS
**
**  UNIX has a stream file system and does not support the different file
**  formats - they are all written as stream files.  Text and binary files
**  are not differentiated either.
**----------------------------------------------------------------------------
*/
# define SUPPORT_FIXED_FMT          FALSE
# define SUPPORT_STREAM_FMT         TRUE
# define SUPPORT_VARIABLE_FMT       FALSE

# define TEXT_LINE_OVERHEAD         0

# define DEF_MODE                   MODE_BINARY
# define DEF_TEXT_FMT               FMT_STREAM
# define DEF_BINARY_FMT             FMT_STREAM

# define MIN_VARIABLE_RECORD_LEN    INV_RECORD_LEN
# define MAX_VARIABLE_RECORD_LEN    INV_RECORD_LEN
# define DEF_VARIABLE_RECORD_LEN    INV_RECORD_LEN

# define MIN_FIXED_RECORD_LEN       INV_RECORD_LEN
# define MAX_FIXED_RECORD_LEN       INV_RECORD_LEN
# define DEF_FIXED_RECORD_LEN       INV_RECORD_LEN

# define DEF_TEXT_PADCHAR           0
# define DEF_BINARY_PADCHAR         0

#endif                          /* (OS_UNIX) */



/*
**============================================================================
** OS_VAXVMS
**
**  Digital Equipment Corporation's proprietary VMS operating system for their
**  VAX series of computers.  The versions and VMS and compilers supported
**  are:
**
**      VAX/VMS v5.1 - v5.4-1
**
**      VMS cc v3                   VMS_VAXC
**      GNU C v1.38                 VMS_GNUC
**
**============================================================================
*/
#if (OS_VAXVMS)

/*
**----------------------------------------------------------------------------
** GENERAL DEFINITIONS
**
**  The VAX/VMS C compiler supports most of the ANSI standard.
**----------------------------------------------------------------------------
*/
# define VV_OPERATING_SYSTEM        "VAX-VMS"

# if (VMS_VAXC)
#  define VV_IMPLEMENTATION         "VAX/VMS C"
#  define ANSI_SYNTAX               TRUE
# endif                          /* (VMS_VAXC) */

# if (VMS_GNUC)
#  define VV_IMPLEMENTATION         "VAX/VMS GNU C"
#  define ANSI_SYNTAX               TRUE
# endif                          /* (VMS_GNUC) */

/*-
**----------------------------------------------------------------------------
** INCLUDE FILES
**----------------------------------------------------------------------------
*/
# include <stddef.h>
# include <stdlib.h>
# include <string.h>
# include <errno.h>
# include <ctype.h>
# include <stat.h>
# include <time.h>
# include <types.h>
# include <unixio.h>

/*
**----------------------------------------------------------------------------
** COMMAND LINE INTERFACE
**
**  VAX/VMS qualifiers are usually introduced with a '/' and values separated
**  with an '='.  A typical command line would be:
**
**      program  /qualifier  file1  /qual=VALUE  file2
**
** The VMS system utilities for command line parsing are used by VVCODE.
** These definitions are used mainly for printing help and error messages.
**----------------------------------------------------------------------------
*/
# define QUAL_INTRO                 "/"
# define QUAL_SEP                   "=:"
# define OPTIONAL_QUALIFIER_VALUES  TRUE
# define STICKY_DEFAULTS            TRUE
# define STDOUT_OUTPUT              FALSE
# define SUPPORT_PIPING             FALSE
# define STDIO_SYMBOL               "-"

/*
**----------------------------------------------------------------------------
** FILE SPECIFICATION PARSING
**
**  The general VAX/VMS file specification has six components in the form:
**
**          node::device:[dir1.dir2]name.ext;version
**          node::device:<dir1.dir2>name.ext;version
**
**  The preamble is terminated by one of ':', ']' or '>'
**  The extension is terminated by ';'
**----------------------------------------------------------------------------
*/
# define MAX_PATH                   255
# define MAX_PREAMBLE               255
# define MAX_NAME                   39
# define MAX_EXT                    39
# define MAX_POSTAMBLE              5

# define PREAMBLE_END               ":>]"
# define EXTENSION_BEGIN            '.'
# define POSTAMBLE_BEGIN            ";"
# define UPPERCASE_FILESYSTEM       TRUE

# define LEGAL_FILESPEC_CHARS \
 "$-_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890"
# define REPLACEMENT_FILESPEC_CHAR  '_'

/*
**----------------------------------------------------------------------------
** FILE FORMATS
**
**  VAX/VMS has a record/block oriented stream file system and supports all of
**  the different file formats.  The default format for text files is variable
**  length records and for binary files, fixed length records.
**----------------------------------------------------------------------------
*/
# define SUPPORT_FIXED_FMT          TRUE
# define SUPPORT_STREAM_FMT         TRUE
# define SUPPORT_VARIABLE_FMT       TRUE

# define TEXT_LINE_OVERHEAD         1

# define DEF_MODE                   MODE_BINARY
# define DEF_TEXT_FMT               FMT_VARIABLE
# define DEF_BINARY_FMT             FMT_FIXED

# define MIN_VARIABLE_RECORD_LEN    0L
# define MAX_VARIABLE_RECORD_LEN    32765L
# define DEF_VARIABLE_RECORD_LEN    0L

# define MIN_FIXED_RECORD_LEN       2
# define MAX_FIXED_RECORD_LEN       32767L
# define DEF_FIXED_RECORD_LEN       512L

# define DEF_TEXT_PADCHAR           ' '
# define DEF_BINARY_PADCHAR         '\0'

#endif                          /* (OS_VAXVMS) */



/*
**============================================================================
** OS_VMCMS
**
**  IBM's VM/CMS operating system for their S/370 and S/390 series of 
**  computers.  The versions of VM/CMS and compilers supported
**  are:
**
**      VM/CMS version ?
**
**      Waterloo C version ?
**      
**
**============================================================================
*/
#if (OS_VMCMS)

/*
**----------------------------------------------------------------------------
** GENERAL DEFINITIONS
**
**  The VM/CMS C compiler supports most of the ANSI standard.
**----------------------------------------------------------------------------
*/
# define VV_OPERATING_SYSTEM        "VM/CMS"
# define VV_IMPLEMENTATION          "VM/CMS C"
# define ANSI_SYNTAX                TRUE

/*-
**----------------------------------------------------------------------------
** INCLUDE FILES
**----------------------------------------------------------------------------
*/
# include <stddef.h>
# include <stdlib.h>
# include <string.h>
# include <errno.h>
# include <ctype.h>
# include <time.h>
# include <types.h>

/*
**----------------------------------------------------------------------------
** COMMAND LINE INTERFACE
**
**  VM/CMS qualifiers are usually introduced with a '(' and values separated
**  with a ':'.  A typical command line would be:
**
**      program  (qualifier)  file1  (qual:VALUE)  file2
**
** The VM/CMS system utilities for command line parsing are used by VVCODE.
** These definitions are used mainly for printing help and error messages.
**----------------------------------------------------------------------------
*/
# define QUAL_INTRO                 "("
# define QUAL_SEP                   "=:"
# define OPTIONAL_QUALIFIER_VALUES  TRUE
# define STICKY_DEFAULTS            TRUE
# define STDOUT_OUTPUT              FALSE
# define SUPPORT_PIPING             FALSE
# define STDIO_SYMBOL                "-"

/*
**----------------------------------------------------------------------------
** FILE SPECIFICATION PARSING
**
**  The general VM/CMS file specification has three components in the form:
**
**      filename filetype filemode
**
**  which is often supported by C compilers as
**
**      filename.filetype.filemode
**
**  The name and extension components are terminated by ' '.
**----------------------------------------------------------------------------
*/
# define MAX_PATH                   19
# define MAX_PREAMBLE               0
# define MAX_NAME                   8
# define MAX_EXT                    9
# define MAX_POSTAMBLE              3

# define PREAMBLE_END               ""
# define EXTENSION_BEGIN            ' '
# define POSTAMBLE_BEGIN            " "
# define UPPERCASE_FILESYSTEM       FALSE

# define LEGAL_FILESPEC_CHARS \
 "-abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890"
# define REPLACEMENT_FILESPEC_CHAR   'X'

/*
**----------------------------------------------------------------------------
** FILE OPENING
**
**  VM/CMS has a record/block oriented stream file system and supports
**  variable length and fixed format files.  The default format for text files
**  is variable length records and for binary files, fixed length records.
**----------------------------------------------------------------------------
*/
# define SUPPORT_FIXED_FMT          FALSE
# define SUPPORT_STREAM_FMT         TRUE
# define SUPPORT_VARIABLE_FMT       TRUE

# define TEXT_LINE_OVERHEAD         1

# define DEF_MODE                   MODE_BINARY
# define DEF_TEXT_FMT               FMT_VARIABLE
# define DEF_BINARY_FMT             FMT_FIXED

# define MIN_VARIABLE_RECORD_LEN    0L
# define MAX_VARIABLE_RECORD_LEN    65535L
# define DEF_VARIABLE_RECORD_LEN    0L

# define MIN_FIXED_RECORD_LEN       2L
# define MAX_FIXED_RECORD_LEN       32760L
# define DEF_FIXED_RECORD_LEN       512L

# define DEF_TEXT_PADCHAR           ' '
# define DEF_BINARY_PADCHAR         '\0'

#endif                          /* (OS_VMCMS) */
