
set alpha::registered 1

proc alpha::checkRegistration {} {
    if {[alpha::codeOk]} {return}
    variable registration
    variable userName
    variable daysOfUse
    ensureset daysOfUse 0
    ensureset userName ""
    set count 0
    if {![string length $userName]} {
	set firstUse 1
    } else {
	set firstUse 0
    }
    set daysLeft [expr {25 - $daysOfUse}]
    if {$daysLeft != 1} {
	append daysLeft " days"
    } else {
	append daysLeft " day"
    }
    while {1} {
	set resvar ""
	set y 10
	set args [dialog::text "Please register AlphaTk" 50 y]
	incr y 5
	eval lappend args [dialog::text "Welcome to AlphaTk.\
	  You may use AlphaTk freely for 25 days.  If you decide to\
	  continue using AlphaTk beyond that time, you must register\
	  and pay for the software.  Once your payment has been received\
	  you will be sent a registration code to allow full, unhampered\
	  access to AlphaTk." 20 y 85]
	
	if {$firstUse} {
	    eval lappend args [dialog::textedit "User name" $userName 40 y 20 1 100]
	    lappend resvar userName
	} else {
	    eval lappend args [dialog::text "User name: $userName" 40 y]
	}
	incr y 5
	if {$daysOfUse < 26} {
	    if {$firstUse} {
		eval lappend args [dialog::text "If you would like to\
		  evaluate AlphaTk for 25 days, please leave the following\
		  field blank." 20 y 85]
	    } else {
		eval lappend args [dialog::text "If you would like to\
		  continue evaluating AlphaTk (you have $daysLeft left),\
		  please leave the following\
		  field blank.  If you have paid for and registered AlphaTk,\
		  please enter your registration code below." 20 y 85]
	    }
	} else {
	    eval lappend args [dialog::text "You've used AlphaTk for\
	      at least $daysOfUse days.  If you use AlphaTk beyond this time,\
	      you must pay for it.  If you do not quit now you are breaking\
	      the licence agreement." 20 y]
	}
	incr y 5
	eval lappend args [dialog::textedit "Registration code" "" 40 y 20 1 100]
	lappend resvar registration
	incr y 15
	
	set x 20
	eval lappend args [dialog::button "Ok" "" y "Quit" "" y]
	lappend resvar ok quit
	foreach var $resvar val [eval dialog -w 480 -h $y $args] {
	    set $var $val
	}
	if {$quit} {
	    quit
	}
	if {[string trim $userName] != ""} {
	    if {[alpha::codeOk]} {
		alertnote "Thank you for registering, $userName."
		break
	    } else {
		if {$registration == ""} {
		    if {$daysOfUse < 26} {
			alertnote "You have $daysLeft left to\
			  evaluate AlphaTk.  I hope you find it useful.\
			  Feel free to send feedback to vince@santafe.edu"
			break
		    } else {
			set txt "You have already used AlphaTk for\
			  $daysOfUse days.  If you want to continue using\
			  AlphaTk, please pay for and register it.  Thank You."
			if {$count > 2} {
			    append txt "\nPlease register as soon as possible."
			    alertnote $txt
			    break
			} else {
			    append txt "\nPress Ok to enter a registration code."
			    alertnote $txt
			}
		    }
		} else {
		    alertnote "That code is invalid.  Please enter another."
		    set registration ""
		}
	    }
	} else {
	    alertnote "You must enter your name to use AlphaTk"
	}
    }
    
    
}

proc alpha::codeOk {} {
    variable registration
    return 1
}
