## -*-Tcl-*-
 # ###################################################################
 #  HTML mode - tools for editing HTML documents
 # 
 #  FILE: "HTMLCompletions.tcl"
 #                                    created: 98-04-05 21.30.48 
 #                                last update: 99-04-24 13.20.59 
 #  Author: Johan Linde
 #  E-mail: <jlinde@telia.com>
 #     www: <http://www.theophys.kth.se/~jl/Alpha.html>
 #  
 # Version: 2.1.4
 # 
 # Copyright 1996-1999 by Johan Linde
 #  
 # This software may be used freely, and distributed freely, as long as the 
 # receiver is not obligated in any way by receiving it.
 #  
 # If you make improvements to this file, please share them!
 # 
 # ###################################################################
 ##

# We want to be able to use CSS and JavaScript completions in HTML documents.
catch {uplevel #0 {source "$HOME:Tcl:Completions:CSSCompletions.tcl"}}
catch {uplevel #0 {source "$HOME:Tcl:Completions:JScrCompletions.tcl"}}


set completions(HTML) {word completion::word}

# If current position is inside a tag, complete the tag or attributes
# being written.
proc HTML::Completion::word {dummy} {
	global htmlElemAttrOptional1 HTMLmodeVars htmlColorAttr mode htmlElemKeyBinding
	global basicColors htmluserColors htmlSpecColor htmlURLAttr htmlSpecURL HTMLmodeVars
	global htmlSpecWindow htmlWindowAttr elecStopMarker
	
	if {[htmlIsInContainer SCRIPT]} {
		# Pretend to be in JavaScript mode
		set mode JScr
		catch {bind::Completion}
		set mode HTML
		return 1
	}
	if {[htmlIsInContainer STYLE]} {
		hctsmsl.tcl
		# Pretend to be in CSS mode.
		set mode CSS
		catch {bind::Completion}
		set mode HTML
		return 1
	}
	
	set pos [getPos]
	set allTags [array names htmlElemAttrOptional1]
	regsub -all {\{INPUT TYPE=[^ ]+} $allTags " " allTags
	lappend allTags INPUT
	
	# Find the tag.
	if {[catch {search -s -f 0 -r 1 -m 0 {<[^ \t\r<>]+} [expr $pos - 1]} left]} {return 0}
	if {![catch {search -s -f 0 -r 0 -m 0 {>} [expr $pos - 1]} right]
	&& [lindex $right 1] > [lindex $left 1] && [lindex $right 0] < $pos} {return 0}
	set tag [string toupper [string range [eval getText $left] 1 end]]
	if {$tag == "LI"} {
		set ltype [htmlFindList]
		if {$ltype == "UL"} {
			set tag "LI IN UL"
		} elseif {$ltype == "OL"} {
			set tag "LI IN OL"
		}			
	}
	# All INPUT elements are defined differently. Must extract TYPE.
	if {$tag == "INPUT"} {
		set dum [expr $pos + 500]
		if {[regexp -nocase {[^<>]* TYPE=\"?([^ \t\r\"<>]+)\"?} [getText [lindex $left 1] [expr $dum < [maxPos] ? $dum : [maxPos]]] dum tag]} {
			set tag [string toupper $tag]
			if {![info exists htmlElemKeyBinding($tag)]} {set tag "INPUT TYPE=$tag"}
		}
	}
	
	set tagBegin [expr [lindex $left 0] + 1]
	set tagEnd [lindex $left 1]
	# opening or closing tag
	set opening 1
	if {[string index $tag 0] == "/"} {
		set tag	[string range $tag 1 end]
		incr tagBegin 1
		set opening 0
	}
	# inside < and > or just right of < ?
	if {![catch {search -s -f 1 -r 0 -m 0 {>} $pos} r1] && 
	![catch {search -s -f 1 -r 0 -m 0 {<} $pos} l1] &&
	[lindex $r1 0] < [lindex $l1 0]} {
		set inside 1
	} else {
		set inside 0
	}
	
	# Are we typing the tag or an attribute?
	if {$tagEnd == $pos} {
		# tag
		set matches ""
		foreach t $allTags {
			if {[string match "$tag*" $t]} {lappend matches $t}
		}
		if {![llength $matches]} {
			select $tagBegin $tagEnd
		} else {
			set newTag [largestPrefix $matches]
			if {!$inside} {
				append newTag >
				if {$HTMLmodeVars(useTabMarks) && ($opening || [llength $matches] > 1)} {append newTag $elecStopMarker}
			}
			replaceText $tagBegin $tagEnd [htmlSetCase $newTag]
			if {!$inside && ($opening || [llength $matches] > 1)} {goto [expr [getPos] - 1 - $HTMLmodeVars(useTabMarks)]}
		}
	} else {
		# Attribute
		if {!$opening} {return 1}
		# are we between quotes to type the attribute value?
		if {![catch {search -s -f 0 -r 1 -m 0 {=\"[^\"]*\"} [expr $pos - 1]} pos5] &&  [lindex $pos5 0] > $tagBegin &&
		[lindex $pos5 1] > $pos} {
			if {![catch {search -s -f 0 -r 1 -m 0 {[ \t\r\"][^ \t\r\"=]+=\"[^\"]*\"} [expr $pos - 1]} attPos] && [lindex $attPos 0] > $tagBegin && 
			[lindex $attPos 1] > $pos} {
				set txt [getText [expr [lindex $attPos 0] + 1] [lindex $attPos 1]]
				regexp {([^=]+=)\"([^\"]*)\"} $txt dum attr val
				set attr [string toupper $attr]
				set begin [expr [lindex $attPos 0] + 2 + [string length $attr]]
				set end [expr [lindex $attPos 1] - 1]
				set choices [htmlGetChoices $tag]
				set isURL 0
				if {[lsearch $choices "$attr*"] < 0} {
					if {[lsearch -exact [concat [htmlGetRequired $tag] [htmlGetOptional $tag]] $attr] < 0} {return 0}
					set isChoice 0
					if {([lsearch -exact $htmlColorAttr $attr] >= 0 && [lsearch -exact $htmlSpecColor "${tag}!=[string trimright $attr =]"] < 0) || \
					[lsearch -exact $htmlSpecColor "${tag}=[string trimright $attr =]"] >= 0} {
						set choices [concat $basicColors [array names htmluserColors]]
					} elseif {([lsearch -exact $htmlURLAttr $attr] >= 0 && [lsearch -exact $htmlSpecURL "${tag}!=[string trimright $attr =]"] < 0) || \
					[lsearch -exact $htmlSpecURL "${tag}=[string trimright $attr =]"] >= 0} {
						set choices $HTMLmodeVars(URLs)
						set isURL 1
					} elseif {([lsearch -exact $htmlWindowAttr $attr] >= 0 && [lsearch -exact $htmlSpecWindow "${tag}!=[string trimright $attr =]"] < 0) || \
					[lsearch -exact $htmlSpecWindow "${tag}=[string trimright $attr =]"] >= 0} {
						set choices [concat _self _blank _top _parent $HTMLmodeVars(windows)]
					} else {
						return 0
					}
				} else {
					set val [string toupper $val]
					set isChoice 1
				}
				
				set matches ""
				foreach c $choices {
					if {$isChoice && [string match "${attr}$val*" $c]} {
						lappend matches [string range $c [string length $attr] end]
					} elseif {!$isChoice && [string match "$val*" $c]} {
						lappend matches $c
					}
				}
				if {![llength $matches]} {
					select $begin $end
				} else {
					set newval [largestPrefix $matches]
					if {$isChoice} {set newval [htmlSetCase $newval]}
					if {$isURL} {set newval [htmlURLescape2 $newval]} 
					replaceText $begin $end $newval
				}
				return 1
			}
		}

		# we are typing the attribute itself.
		set addSpace 0
		if {[set c [lookAt [getPos]]] != " " && $c != ">"} {set addSpace 1} 
		backwardWord
		set attrBegin [getPos]
		set attrEnd $pos
		set attr [string toupper [getText $attrBegin $attrEnd]]
		set eventAtts [htmlGetSomeAttrs $tag EventHandler 1]
		set allAttrs [concat [htmlGetRequired $tag] [string toupper [htmlGetOptional $tag]]]
		if {$tag == "INPUT"} {set allAttrs TYPE=}
		set matches ""
		foreach t $allAttrs {
			if {[string match "$attr*" $t]} {lappend matches $t}
		}
		if {![llength $matches]} {
			select $attrBegin $attrEnd
		} else {
			if {[lookAt [expr $attrBegin - 1]] == "\""} {set newAttr " "}
			append newAttr [largestPrefix $matches]
			if {[set i [lsearch [string toupper $eventAtts] "[string trim $newAttr]*"]] >= 0} {
				set ext ""
				if {[string index $newAttr 0] == " "} {set ext " "}
				set newAttr "$ext[string range [lindex $eventAtts $i] 0 [expr [string length [string trim $newAttr]] - 1]]"
			} else {
				set newAttr [htmlSetCase $newAttr]
			}
			set backup 1
			if {[llength $matches] == 1} {
				if {[regexp {=} $newAttr]} {
					append newAttr "\"\""
					if {$HTMLmodeVars(useTabMarks)} {append newAttr $elecStopMarker}
				}
				if {$addSpace} {append newAttr " "; set backup 2} 
			}
			replaceText $attrBegin $attrEnd $newAttr
			if {[llength $matches] == 1 && [regexp {=} $newAttr]} {goto [expr [getPos] - $backup - $HTMLmodeVars(useTabMarks)]}
		}
	}
	return 1
}
