/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "cpptcl_subcommands.h"
 *                                    created: 29/10/97 {4:53:12 pm} 
 *                                last update: 15/12/97 {4:24:02 pm} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *  Description: 
 * 
 *  History
 * 
 *  modified by  rev reason
 *  -------- --- --- -----------
 *  29/10/97 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_cpptcl_subcommands_
#define _Cpptcl_cpptcl_subcommands_

#include "meta_type.h"

//@Section: Cpptcl library
///
class cpptcl_subcommand {
  public:
	///
	Tcl_Obj* subcommand;
	///
	Tcl_Obj* associated_proc;
	///
	Tcl_Obj* syntax;
	///
	Tcl_Obj* help;
	///
	cpptcl_subcommand(const Tcl_Obj* sub, const Tcl_Obj* proc, 
					const Tcl_Obj* sy=0, const Tcl_Obj *h=0) {
		subcommand = Tcl_DuplicateObj((Tcl_Obj*)sub);
		Tcl_IncrRefCount(subcommand);
		associated_proc = Tcl_DuplicateObj((Tcl_Obj*)proc);
		Tcl_IncrRefCount(associated_proc);
		if(sy) {
			syntax = Tcl_DuplicateObj((Tcl_Obj*)sy);
			Tcl_IncrRefCount(syntax);
		} else {
			syntax = 0;
		}
		if(h) {
			help = Tcl_DuplicateObj((Tcl_Obj*)h);
			Tcl_IncrRefCount(help);
		} else {
			help = 0;
		}
	}
	///
	~cpptcl_subcommand(void) {
		Tcl_DecrRefCount(subcommand);
		Tcl_DecrRefCount(associated_proc);
		if(syntax)
			Tcl_DecrRefCount(syntax);
		if(help)
			Tcl_DecrRefCount(help);
	}
};

#endif
