/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl	 
 * 
 *	FILE: "tcl_object.h"
 *								   created:	29/5/96 {12:32:24 am}
 *								   last update: 19/11/97 {1:55:01 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: darley@fas.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *  
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	23/1/95	 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_tcl_object_
#define _Cpptcl_tcl_object_

#include "cpptclInt.h"
#include "tcl_base.h"
#include "tcl_obj.h"
#include "cpptcl_type.h"
#include "tcl_args.h"

class cpptcl_subcommand;

//@Section: Cpptcl library
//@Man:
/** 
 * -------------------------------------------------------------------------
 *   
 * "class tcl_object" --
 *  
 *  This file defines the interface to tcl_base.  A tcl_base is a handy 
 *  abstraction for interfacing C++ to tcl's procedural objects.  When a 
 *  tcl_object is created, it causes a tcl command to be created with 
 *  clientData pointing to the tcl_object.  When the tcl command is invoked 
 *  (from tcl), the arguments are passed to tcl_object::parse_tcl_command() 
 *  via the clientData associated with the tcl command.
 * 
 *  A tcl_object knows the name of its tcl command, and the interpreter under 
 *  which it was created.  instances of tcl_object can be created, but the
 *  basic command in Tcl would have a single method 'rename' to change its
 *  name.  Therefore you should derive from this class and add your own
 *  'parse_tcl_command' function of the following form:
 *
 *	   int my_object::parse_tcl_command(tcl_args& arg){
 *		   if (arg("syntax","help text")=="cmd") {
 *			   // extract any more arguments	
 *			   DONE(arg);
 *			   // execute 'cmd'	
 *			   return tcl_;
 *		   ...
 *		   } else if(arg(...)=="...") {
 *		   ...
 *		   } else {
 *			   return parent_object::parse_tcl_command(arg);
 *		   }
 *	   }
 *
 *  A tcl_object may be created explicitly in C++, or it may be created
 *  from Tcl by creating a companion 'tcl_class', whose sole purpose is
 *  the creation of instances of 'tcl_objects'.  In general if your class
 *  is designed as a real object of which there will be many instances,
 *  then you will want to create a tcl_class companion.  If you require
 *  just a single instance, then you should just create that in C++ and
 *  be done.  
 *   
 * --Version--Author------------------Changes-------------------------------  
 *    1.0     <darley@fas.harvard.edu> original
 * -------------------------------------------------------------------------
 */
DLL_IMPORT_EXPORT
class tcl_object : public tcl_base {
  public:
	
	/// We need to know our interpreter and the name of our tcl command
	tcl_object(tcl_obj& o, Tcl_Obj* name):tcl_base(o,name) {}
	/// We need to know our interpreter and the name of our tcl command
	tcl_object(tcl_obj& o, const char* name):tcl_base(o,name) {}

	/// Although these can be read from an arg list if desired.
	tcl_object(tcl_args& arg):tcl_base(arg) {}

	/// Destroys my associated command in the Tcl interpreter
  	~tcl_object() {}

	/// To be supplied by derived classes
   /** 
	* Derived classes should supply	this function. It looks through 
	* the arguments	and	does whatever it wants.	 The intention is for 
	* parse_tcl_command	to decide which	member function	to call, 
	* prepare the arguments	to that	member function	(perhaps 
	* converting strings to	ints or	suchlike), then	call the member	
	* function to do the actual	work.  #parse_tcl_command# should just 
	* be a parser, as the name implies.
	*/
    virtual int parse_tcl_command(tcl_args& arg);
	/// Called after meta_object construction to deal with command line args
	/**
	 * You may wish	to over-ride it, although default	
	 * configuration handling of members is automatic.
	 */
	virtual int parse_configuration_values(tcl_args& arg);
	/// Parse the rest of the line as configuration args.  Error if none.
	int parse_configuration_args(tcl_args& arg);
	/// this is the object type.
	tcl_object* the_object(void) { return this;}
	///
	virtual int contains(tcl_args& arg, tcl_object** &where) const;
  protected:
	///
	int parse_subcommands(tcl_args& arg);
	///
	cpptcl_subcommand* subcommand(tcl_args& arg, const meta_object& o);
    /// Copy constructor
    tcl_object(const tcl_object& o):tcl_base(o) {}

  public:
	/// allows you to initialise an object after construction, but before use
	virtual void initialise(void) {}
		
};


#endif
