# frozen_string_literal: true

module Mutations
  module MergeRequests
    class SetSubscription < BaseMutation
      graphql_name 'MergeRequestSetSubscription'

      include ResolvesSubscription
      include Mutations::ResolvesIssuable

      argument :project_path, GraphQL::Types::ID,
               required: true,
               description: "Project the merge request to mutate is in."

      argument :iid, GraphQL::Types::String,
               required: true,
               description: "IID of the merge request to mutate."

      field :merge_request,
            Types::MergeRequestType,
            null: true,
            description: "Merge request after mutation."

      authorize :update_subscription

      private

      def find_object(project_path:, iid:)
        resolve_issuable(type: :merge_request, parent_path: project_path, iid: iid)
      end
    end
  end
end
