# frozen_string_literal: true

class AddUuidProjectIdStateIdIndexToVulnerabilityReads < Gitlab::Database::Migration[2.1]
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_reads_on_uuid_project_id_and_state'

  def up
    add_concurrent_index :vulnerability_reads, [:uuid, :project_id, :state], name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_NAME
  end
end
