---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 'Learn how to use and administer GitLab, the most scalable Git-based fully integrated platform for software development.'
---

# GitLab: The DevSecOps platform

 DevSecOps is a combination of development, security, and operations.
 It is an approach to software development that integrates security throughout the development lifecycle.

## DevSecOps compared to DevOps

DevOps combines development and operations, with the intent to increase the efficiency,
speed, and security of software development and delivery.

DevOps means working together to conceive, build, and deliver secure software at top speed.
DevOps practices include automation, collaboration, fast feedback, and iterative improvement.

DevSecOps is an evolution of DevOps. DevSecOps includes application security practices in every stage of software development.

Throughout the development process, tools and methods protect and monitor your live applications.
New attack surfaces, like containers and orchestrators, must also be monitored and protected.
DevSecOps tools automate security workflows to create an adaptable process for your development
and security teams, improving collaboration and breaking down silos.
By embedding security into the software development lifecycle, you can consistently secure fast-moving
and iterative processes, improving efficiency without sacrificing quality.

## DevSecOps fundamentals

DevSecOps fundamentals include:

- Automation
- Collaboration
- Policy guardrails
- Visibility

For details, see [this article about DevSecOps](https://about.gitlab.com/topics/devsecops/).

## Is DevSecOps right for you?

If your organization is facing any of the following challenges, a DevSecOps approach might be for you.

- **Development, security, and operations teams are siloed.**  
  If development and operations are isolated from security issues,
  they can't build secure software. And if security teams aren't part of the development process,
  they can't identify risks proactively. DevSecOps brings teams together to improve workflows
  and share ideas. Organizations might even see improved employee morale and retention.

- **Long development cycles are making it difficult to meet customer or stakeholder demands.**  
  One reason for the struggle could be security. DevSecOps implements security at every step of
  the development lifecycle, meaning that solid security doesn't require the whole process to come to a halt.

- **You're migrating to the cloud (or considering it).**  
  Moving to the cloud often means bringing on new development processes, tools, and systems.
  It's a great time to make processes faster and more secure — and DevSecOps could make that a lot easier.

To get started with DevSecOps,
[learn more, and try GitLab Ultimate for free](https://about.gitlab.com/solutions/security-compliance/).
