# frozen_string_literal: true

module Gitlab
  module BackgroundMigration
    # Sets the `has_merge_request` of the existing `vulnerability_reads` records
    class BackfillHasMergeRequestOfVulnerabilityReads < BatchedMigrationJob
      operation_name :set_has_merge_request
      feature_category :database

      UPDATE_SQL = <<~SQL
        UPDATE
          vulnerability_reads
        SET
          has_merge_request = true
        FROM
          (%<subquery>s) as sub_query
        WHERE
          vulnerability_reads.vulnerability_id = sub_query.vulnerability_id
      SQL

      def perform
        each_sub_batch do |sub_batch|
          update_query = update_query_for(sub_batch)

          connection.execute(update_query)
        end
      end

      private

      def update_query_for(sub_batch)
        subquery = sub_batch.joins("
          INNER JOIN vulnerability_merge_request_links ON
          vulnerability_reads.vulnerability_id =
          vulnerability_merge_request_links.vulnerability_id")

        format(UPDATE_SQL, subquery: subquery.to_sql)
      end
    end
  end
end
