---
stage: Govern
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Enforce two-factor authentication

DETAILS:
**Tier:** Free, Premium, Ultimate
**Offering:** GitLab.com, Self-managed, GitLab Dedicated

[Two-factor authentication (2FA)](../user/profile/account/two_factor_authentication.md)
is an authentication method that requires the user to provide two different factors
to prove their identity:

- Username and password.
- A second authentication method, such as a code generated by an application.

2FA makes it harder for an unauthorized person to access an account because
they would need both factors.

NOTE:
If you are [using and enforcing SSO](../user/group/saml_sso/index.md#sso-enforcement), you might already be enforcing 2FA on the identity provider (IDP) side. Enforcing 2FA on GitLab as well might be unnecessary.

## Enforce 2FA for all users

DETAILS:
**Tier:** Free, Premium, Ultimate
**Offering:** Self-managed, GitLab Dedicated

Administrators can enforce 2FA for all users in two different ways:

- Enforce on next sign in.
- Suggest on next sign in, but allow a grace period before enforcing.

  After the configured grace period has elapsed, users can sign in but
  cannot leave the 2FA configuration area at `/-/profile/two_factor_auth`.

You can use the UI or the API to enforce 2FA for all users.

### Use the UI

1. On the left sidebar, at the bottom, select **Admin**.
1. Select **Settings > General**.
1. Expand **Sign-in restrictions**:
   - Select **Enforce two-factor authentication** to enable this feature.
   - In **Two-factor grace period**, enter a number of hours. If you want to
     enforce 2FA on next sign-in attempt, enter `0`.

### Use the API

Use the [application settings API](../api/settings.md) to modify the following settings:

- `require_two_factor_authentication`.
- `two_factor_grace_period`.

For more information, see the [list of settings that can be accessed through API calls](../api/settings.md#list-of-settings-that-can-be-accessed-via-api-calls).

## Enforce 2FA for Administrator users

DETAILS:
**Tier:** Free, Premium, Ultimate
**Offering:** Self-managed, GitLab Dedicated

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/427549) in GitLab 16.8.

Administrators can enforce 2FA for administrator users in a self-managed instance.

1. On the left sidebar, at the bottom, select **Admin**.
1. On the left sidebar, select **Settings > General**.
1. Expand the **Sign-in restrictions** section:
    - Select **Require administrators to enable 2FA**.
    - In **Two-factor grace period**, enter a number of hours. If you want to
      enforce 2FA on the next sign-in attempt, enter `0`.
1. Select **Save changes**.

NOTE:
If you are using an external provider to sign in into GitLab, this setting will **not** enforce 2FA for users. 2FA should be enabled on that external provider.

## Enforce 2FA for all users in a group

DETAILS:
**Tier:** Free, Premium, Ultimate
**Offering:** GitLab.com, Self-managed, GitLab Dedicated

Prerequisites:

- You must have the Maintainer or Owner role for the group.

To enforce 2FA only for certain groups:

1. On the left sidebar, select **Search or go to** and find your group.
1. Select **Settings > General**.
1. Expand **Permissions and group features**.
1. Select **All users in this group must set up two-factor authentication**.
1. Optional. In **Delay 2FA enforcement (hours)**, enter the number of hours you
   want the grace period to last for.
   If there are multiple different grace periods in a top level group and its subgroups
   and projects, the shortest grace period is used.
1. Select **Save changes**.

Enforcement affects all [direct and inherited members](../user/project/members/index.md#membership-types) in the group.

Access tokens are not required to provide a second factor for authentication because
they are API-based. Tokens generated before 2FA is enforced remain valid.

The GitLab [incoming email](../administration/incoming_email.md) feature does not follow 2FA enforcement. Users can use incoming email features such as creating issues or commenting on merge requests without having to authenticate themselves using 2FA first. This applies even if 2FA is enforced.

### 2FA in subgroups

You can enable and enforce 2FA for individual subgroups in the same way as a top
level group.

You can prevent subgroups from setting up their own 2FA requirements:

1. Go to the top level group's **Settings > General**.
1. Expand the **Permissions and group features** section.
1. Clear the **Allow subgroups to set up their own two-factor authentication rule** checkbox.

This action causes all subgroups with 2FA requirements to stop requiring 2FA from
their members.

### 2FA in projects

If a project belonging to a group that enables or enforces 2FA is [shared](../user/project/members/share_project_with_groups.md)
with a group that does not enable or enforce 2FA, members of the non-2FA group can access that project
without using 2FA. For example:

- Group *A* has 2FA enabled and enforced. Group *B* does not have 2FA enabled.
- If a project, *P*, that belongs to group *A* is shared with group *B*, members
  of group *B* can access project *P* without 2FA.

To ensure this does not occur, [prevent sharing of projects](../user/group/access_and_permissions.md#prevent-a-project-from-being-shared-with-groups)
for the 2FA group.

If you add members to a project in a group or subgroup that has 2FA
enabled, 2FA is **not** required for those individually added members.

## Disable 2FA

DETAILS:
**Tier:** Free, Premium, Ultimate
**Offering:** Self-managed

You can disable 2FA for a single user or all users.

This is a permanent and irreversible action. Users must reactivate 2FA to use it again.

WARNING:
Disabling 2FA for users does not disable the [enforce 2FA for all users](#enforce-2fa-for-all-users)
or [enforce 2FA for all users in a group](#enforce-2fa-for-all-users-in-a-group)
settings. You must also disable any enforced 2FA settings so users aren't asked to set up 2FA again
when they next sign in to GitLab.

### For a single user

#### Administrators

It is possible to use the [Rails console](../administration/operations/rails_console.md)
to disable 2FA for a single administrator:

```ruby
admin = User.find_by_username('<USERNAME>')
user_to_disable = User.find_by_username('<USERNAME>')

TwoFactor::DestroyService.new(admin, user: user_to_disable).execute
```

The administrator is notified that 2FA has been disabled.

#### Non-administrators

In GitLab 15.2 and later, you can use either the Rails console or the
[API endpoint](../api/users.md#disable-two-factor-authentication) to disable 2FA
for a non-administrator.

You can disable 2FA for your own account.

You cannot use the API endpoint to disable 2FA for administrators.

### For all users

To disable 2FA for all users even when forced 2FA is disabled, use the following Rake task.

- For installations that use the Linux package:

  ```shell
  sudo gitlab-rake gitlab:two_factor:disable_for_all_users
  ```

- For self-compiled installations:

  ```shell
  sudo -u git -H bundle exec rake gitlab:two_factor:disable_for_all_users RAILS_ENV=production
  ```

## 2FA for Git over SSH operations

DETAILS:
**Tier:** Premium, Ultimate
**Offering:** Self-managed

> - It's deployed behind a feature flag, disabled by default.
> - Push notification support [introduced](https://gitlab.com/gitlab-org/gitlab-shell/-/issues/506) in GitLab 15.3.

FLAG:
On self-managed GitLab, by default this feature is not available. To make it available, an administrator can [enable the feature flag](../administration/feature_flags.md) named `two_factor_for_cli`. On GitLab.com and GitLab Dedicated, this feature is not available. This feature is not ready for production use. This feature flag also affects [session duration for Git Operations when 2FA is enabled](../administration/settings/account_and_limit_settings.md#customize-session-duration-for-git-operations-when-2fa-is-enabled).

You can enforce 2FA for [Git over SSH operations](../development/gitlab_shell/features.md#git-operations). However, you should use
[ED25519_SK](../user/ssh.md#ed25519_sk-ssh-keys) or [ECDSA_SK](../user/ssh.md#ecdsa_sk-ssh-keys) SSH keys instead. 2FA is enforced for Git operations only, and internal commands such as [`personal_access_token`](../development/gitlab_shell/features.md#personal-access-token) are excluded.

To perform one-time password (OTP) verification, run:

```shell
ssh git@<hostname> 2fa_verify
```

Then authenticate by either:

- Entering the correct OTP.
- In GitLab 15.3 and later, responding to a device push notification if
  [FortiAuthenticator is enabled](../user/profile/account/two_factor_authentication.md#enable-one-time-password-using-fortiauthenticator).

After successful authentication, you can perform [Git over SSH operations](../development/gitlab_shell/features.md#git-operations) for 15 minutes (default) with the associated
SSH key.

### Security limitation

2FA does not protect users with compromised *private* SSH keys.

Once an OTP is verified, anyone can run Git over SSH with that private SSH key for
the configured [session duration](../administration/settings/account_and_limit_settings.md#customize-session-duration-for-git-operations-when-2fa-is-enabled).

<!-- ## Troubleshooting

Include any troubleshooting steps that you can foresee. If you know beforehand what issues
one might have when setting this up, or when something is changed, or on upgrading, it's
important to describe those, too. Think of things that may go wrong and include them here.
This is important to minimize requests for support, and to avoid doc comments with
questions that you know someone might ask.

Each scenario can be a third-level heading, for example `### Getting error message X`.
If you have none to add when creating a doc, leave this section in place
but commented out to help encourage others to add to it in the future. -->
